% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{pp_conn}
\alias{pp_conn}
\title{Generate planted partition (PP) connectivity matrix}
\usage{
pp_conn(
  n,
  oir,
  lambda,
  pri,
  theta = rep(1, n),
  normalize_theta = FALSE,
  d = rep(1, length(pri))
)
}
\arguments{
\item{n}{the number of nodes}

\item{oir}{out-in-ratio}

\item{lambda}{the expected average degree}

\item{pri}{the prior on community labels}

\item{theta}{node connection propensity parameter of DCSBM}

\item{normalize_theta}{whether to normalize theta so that max(theta) == 1}

\item{d}{diagonal of the connectivity matrix. An all-one vector by default.}
}
\value{
The connectivity matrix B of the desired DCSBM.
}
\description{
Create a degree-corrected planted partition connectivity matrix with a given
average expected degree.
}
\keyword{models}
