% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_bivar.R
\name{entropy_bivar}
\alias{entropy_bivar}
\title{Bivariate Entropy}
\usage{
entropy_bivar(dat)
}
\arguments{
\item{dat}{dataframe with rows as observations and columns as variables. Variables must all be observed or transformed categorical with finite range spaces.}
}
\value{
Upper triangular matrix giving bivariate entropies between pairs of variables given as
rows and columns of the matrix. The univariate entropies are given in the diagonal.
}
\description{
Computes the bivariate entropies between all pairs of (discrete) variables in a multivariate data set.
}
\details{
The bivariate entropy \emph{H(X,Y)} of two discrete random variables \emph{X} and \emph{Y}
can be used to check for functional relationships and stochastic independence between pairs of variables.
The bivariate entropy is bounded according to \cr

\emph{H(X) <= H(X,Y) <= H(X) + H(Y)}
\cr

where \emph{H(X)} and
\emph{H(Y)} are the univariate entropies.
}
\examples{
# use internal data set
data(lawdata)
df.att <- lawdata[[4]]

# three steps of data editing:
# 1. categorize variables 'years' and 'age' based on
# approximately three equally size groups (values based on cdf)
# 2. make sure all outcomes start from the value 0 (optional)
# 3. remove variable 'senior' as it consists of only unique values (thus redundant)
df.att.ed <- data.frame(
    status = df.att$status,
    gender = df.att$gender,
    office = df.att$office - 1,
    years = ifelse(df.att$years <= 3, 0,
        ifelse(df.att$years <= 13, 1, 2)
    ),
    age = ifelse(df.att$age <= 35, 0,
        ifelse(df.att$age <= 45, 1, 2)
    ),
    practice = df.att$practice,
    lawschool = df.att$lawschool - 1
)

# calculate bivariate entropies
H.biv <- entropy_bivar(df.att.ed)
# univariate entropies are then given as
diag(H.biv)
}
\references{
Frank, O., & Shafie, T. (2016). Multivariate entropy analysis of network data.
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie Sociologique}, 129(1), 45-63.
}
\seealso{
\code{\link{joint_entropy}},  \code{\link{entropy_trivar}}, \code{\link{redundancy}}, \code{\link{prediction_power}}
}
\author{
Termeh Shafie
}
