% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_netmhc2pan_data.R
\name{install_netmhc2pan_data}
\alias{install_netmhc2pan_data}
\title{Install the NetMHCIIpan data to a local folder}
\usage{
install_netmhc2pan_data(
  netmhc2pan_data_url = get_netmhc2pan_data_url(),
  netmhc2pan_folder_name = rappdirs::user_data_dir(),
  verbose = FALSE
)
}
\arguments{
\item{netmhc2pan_data_url}{URL to download the
NetMHCIIpan data tarball file from,
similar to, for example,
\url{https://services.healthtech.dtu.dk/services/NetMHCIIpan-3.2/data.Linux.tar.gz}.
Use \link{get_netmhc2pan_data_url} to get the default URL.}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{verbose}{set to TRUE for more output}
}
\value{
Nothing
}
\description{
Install the NetMHCIIpan data to a local folder.
}
\details{
This data can be downloaded from
\url{https://services.healthtech.dtu.dk/services/NetMHCIIpan-3.2/data.Linux.tar.gz},
without filling in a contact form.
}
\author{
Richèl J.C. Bilderbeek
}
