% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmetareg.R
\name{netmetareg.netmeta}
\alias{netmetareg.netmeta}
\alias{netmetareg}
\alias{netmetareg.default}
\alias{print.netmetareg}
\title{Network meta-regression with a single continuous or binary covariate}
\usage{
\method{netmetareg}{netmeta}(
  x,
  covar = NULL,
  consistency = TRUE,
  assumption = "independent",
  method.tau = if (!x$random) "FE" else "REML",
  level = x$level.ma,
  reference.group = x$reference.group,
  nchar.trts = x$nchar.trts,
  ...
)

netmetareg(x, ...)

\method{netmetareg}{default}(x, ...)

\method{print}{netmetareg}(
  x,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  print.se = FALSE,
  details.methods = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{covar}{Continuous or binary covariate.}

\item{consistency}{A logical indicating whether a consistency or
inconsistency model should be assumed.}

\item{assumption}{A character string indicating which assumption is done
for the covariate; either "independent" or "common" (can be abbreviated).}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance tau-squared. Either
\code{"FE"}, \code{"REML"}, or \code{"ML"}.}

\item{level}{The level used to calculate confidence intervals for regression
coefficients.}

\item{reference.group}{Reference treatment.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{\dots}{Additional arguments passed to R function
\code{\link[metafor]{rma.uni}}.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{print.se}{A logical specifying whether standard errors should be
printed.}

\item{details.methods}{A logical specifying whether details on statistical
methods should be printed.}
}
\value{
An object of class \code{c("netmetareg", "rma.mv", "rma")}. Please
look at the help page of R function \code{\link[metafor]{rma.mv}}
for more details on the output from this function.

In addition, a list \code{.netmeta} is added to the output containing
the following components:
\item{x, covar, method.tau}{As defined above.}
\item{dots}{Information provided in argument '\dots{}'.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{netmeta} used to create
  object.}
\item{version.metafor}{Version of R package \bold{metafor} used to
  create object.}
}
\description{
Network meta-regression with a single continuous or binary covariate for
objects of class \code{netmeta}. This is a wrapper function for the R
function \code{\link[metafor]{rma.mv}} in the R package \bold{metafor}
(Viechtbauer 2010).
}
\details{
This R function is a wrapper function for R function
\code{\link[metafor]{rma.mv}} in the R package \bold{metafor}
(Viechtbauer 2010).

Note, results are not back-transformed in printouts of
network meta-analyses using summary measures with transformations, e.g.,
log risk ratios are printed instead of the risk ratio if argument
\code{sm = "RR"}.

Argument '\dots{}' can be used to pass additional arguments to R
function \code{\link[metafor]{rma.mv}}. For example, argument
\code{control} to provide a list of control values for the
iterative estimation algorithm. See help page of R function
\code{\link[metafor]{rma.mv}} for more details.
}
\examples{
\donttest{
data(smokingcessation)
# Add variable with (fictitious) risk of bias values
# with 1 = "low risk" and 2 = "high risk"
#
smokingcessation$rob <- rep(1:2, 12)

pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

net1 <- netmeta(pw1, common = FALSE, ref = "A")

# Network meta-regression with continuous covariate and assumption of
# independent slopes
nr1 <- netmetareg(net1, rob)
nr1
}

}
\references{
Viechtbauer W (2010):
Conducting Meta-Analyses in R with the Metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48
}
\seealso{
\code{\link{netmeta}}
}
\author{
Nana-Adjoa Kwarteng
  \email{nana-adjoa.kwarteng@uniklinik-freiburg.de},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{models}
\keyword{regression}
