% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.subgroup.netmeta.R
\name{forest.subgroup.netmeta}
\alias{forest.subgroup.netmeta}
\alias{plot.subgroup.netmeta}
\title{Forest plot showing results of network meta-analysis with subgroups}
\usage{
\method{forest}{subgroup.netmeta}(
  x,
  pooled = ifelse(x$x$random, "random", "common"),
  equal.size = gs("equal.size"),
  leftcols = c("studlab", "Q", "df.Q", "pval.Q"),
  leftlabs = c("Comparison /\\nSubgroup", "Q", "d.f.", "p-value"),
  rightcols = c("effect", "ci", "k", if (pooled == "random") "tau"),
  rightlabs = c(NA, NA, "Number of\\nStudies", if (pooled == "random") "Tau"),
  calcwidth.subgroup = gs("calcwidth.subgroup"),
  digits = gs("digits.forest"),
  digits.Q = gs("digits.Q"),
  digits.pval.Q = gs("digits.pval.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  sep.trts = " vs ",
  backtransf = x$x$backtransf,
  lab.NA = ".",
  smlab,
  col.subgroup = "black",
  ...
)

\method{plot}{subgroup.netmeta}(x, ...)
}
\arguments{
\item{x}{An object of class \code{subgroup.netmeta}.}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model (\code{"random"})
should be plotted. Can be abbreviated.}

\item{equal.size}{A logical indicating whether all squares should
be of equal size. Otherwise, the square size is proportional to
the precision of estimates.}

\item{leftcols}{A character vector specifying columns to be plotted
on the left side of the forest plot (see Details).}

\item{leftlabs}{A character vector specifying labels for columns on
left side of the forest plot.}

\item{rightcols}{A character vector specifying columns to be
plotted on the right side of the forest plot (see Details).}

\item{rightlabs}{A character vector specifying labels for columns
on right side of the forest plot.}

\item{calcwidth.subgroup}{A logical indicating whether text with
comparison labels should be considered to calculate width of the
column with treatment labels.}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistic Q, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity test, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance \eqn{\tau^2}, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{sep.trts}{A character string used to label treatment comparisons.}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{lab.NA}{A character string to label missing values.}

\item{smlab}{A label printed at top of figure. By default, text
indicating either common or random effects model is printed.}

\item{col.subgroup}{The colour to print information on subgroups.}

\item{\dots}{Additional arguments for \code{\link[meta]{forest.meta}}
function.}
}
\description{
Forest plot to show subgroup estimates of network meta-analysis.
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window.

The arguments \code{leftcols} and \code{rightcols} can be used to
specify columns which are plotted on the left and right side of the
forest plot, respectively. If argument \code{rightcols} is
\code{FALSE}, no columns will be plotted on the right side.

For more information see help page of \code{\link[meta]{forest.meta}}
function.
}
\examples{
\dontrun{
data("Senn2013")
# Add variable with (fictitious) risk of bias values
Senn2013$rob <- NA
set.seed(1909)
for (i in unique(Senn2013$studlab))
  Senn2013$rob[Senn2013$studlab == i] <- sample(1:3, 1)
Senn2013$rob <- factor(Senn2013$rob, levels = 1:3,
  labels = c("low", "moderate", "high"))
# Conduct network meta-analysis
net <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", reference = "plac", nchar.trts = 4)
# Conduct subgroup network meta-analysis
sg <- subgroup(net, rob, common = FALSE)
sg
# Forest plot
forest(sg)
}

}
\seealso{
\code{\link{subgroup.netmeta}}, \code{\link{netmeta}},
  \code{\link[meta]{forest.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
