% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusivity.R
\name{diffusivity}
\alias{diffusivity}
\title{Compute soil diffusivity}
\usage{
diffusivity(
  temperature,
  soil_water,
  pressure,
  temperature_err,
  soil_water_err,
  pressure_err,
  zOffset,
  porVol2To20
)
}
\arguments{
\item{temperature}{Required. Soil temperature (degrees C)}

\item{soil_water}{Required. Soil water content}

\item{pressure}{Required. Barometric air pressure (kilopascal)}

\item{temperature_err}{Required. Reported Soil temperature error (degrees C)}

\item{soil_water_err}{Required. Reported Soil water content error}

\item{pressure_err}{Required. Reported Barometric air pressure error (kilopascal)}

\item{zOffset}{Required. Measurement level in cm.}

\item{porVol2To20}{Required. Porosity of the 0-20 mm fraction (cm3 cm-3). Assumes no pores within rocks.}
}
\value{
A value of the computed diffusivity
}
\description{
Given a tidied data frame of soil measurements (from interpolate.R), compute the diffusivity in a given soil layer
}
\examples{
diffusivity(31,0.0102,96.3,.15,.2135,.05,-.05,0.45)
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
