% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.intcat.R
\name{neg.intcat}
\alias{neg.intcat}
\alias{print.neg.intcat}
\title{Test for Negligible Interaction between Two Categorical Variables
with a Continuous Outcome}
\usage{
neg.intcat(
  iv1 = NULL,
  iv2 = NULL,
  dv = NULL,
  neiL,
  neiU,
  nboot = 50,
  alpha = 0.05,
  data = NULL
)

\method{print}{neg.intcat}(x, ...)
}
\arguments{
\item{iv1}{Levels of the first independent variable}

\item{iv2}{Levels of the second independent variable}

\item{dv}{Score on the continuous dependent/outcome variable}

\item{neiL}{Lower bound of the negligible effect interval}

\item{neiU}{Upper bound of the negligible effect interval}

\item{nboot}{Number of bootstrap samples for calculating CIs}

\item{alpha}{Nominal Type I Error rate}

\item{data}{Dataset containing iv1, iv2 and dv}

\item{x}{object of class \code{neg.twointcat}}

\item{...}{extra arguments}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{meanx} Sample mean of the first population/group.
  \item \code{meany} Sample mean of the second population/group.
  \item \code{trmeanx} Sample trimmed mean of the first population/group.
  \item \code{trmeany} Sample trimmed mean of the second population/group.
  \item \code{sdx} Sample standard deviation of the first population/group.
  \item \code{sdy} Sample standard deviation of the second population/group.
  \item \code{madx} Sample median absolute deviation of the first population/group.
  \item \code{mady} Sample median absolute deviation of the second population/group.
  \item \code{eiL} Lower bound of the negligible effect (equivalence) interval.
  \item \code{eiU} Upper bound of the negligible effect (equivalence) interval.
  \item \code{effsizeraw} Simple difference in the means (or trimmed means if normality = FALSE)
  \item \code{cilraw2} Lower bound of the 1-alpha CI for the raw mean difference.
  \item \code{ciuraw2} Upper bound of the 1-alpha CI for the raw mean difference.
  \item \code{cilraw} Lower bound of the 1-2*alpha CI for the raw mean difference.
  \item \code{ciuraw} Upper bound of the 1-2*alpha CI for the raw mean difference.
  \item \code{effsized} Standardized mean (or trimmed mean if normality = FALSE) difference.
  \item \code{cild} Lower bound of the 1-alpha CI for the standardized mean (or trimmed mean if normality = FALSE) difference.
  \item \code{ciud} Upper bound of the 1-alpha CI for the standardized mean (or trimmed mean if normality = FALSE) difference.
  \item \code{effsizepd} Proportional distance statistic.
  \item \code{cilpd} Lower bound of the 1-alpha CI for the proportional distance statistic.
  \item \code{ciupd} Upper bound of the 1-alpha CI for the proportional distance statistic.
  \item \code{t1} First t-statistic from the TOST procedure.
  \item \code{t1} Second t-statistic from the TOST procedure.
  \item \code{df1} Degrees of freedom for the first t-statistic from the TOST procedure.
  \item \code{df2} Degrees of freedom for the second t-statistic from the TOST procedure.
  \item \code{p1} p value associated with the first t-statistic from the TOST procedure.
  \item \code{p2} p value associated with the second t-statistic from the TOST procedure.
  \item \code{alpha} Nominal Type I error rate
}
}
\description{
This function allows researchers to test whether the
interaction effect among two categorical independent variables, with a
continuous outcome variable, is negligible.
}
\details{
This function allows researchers to test whether the
interaction effect among two categorical independent variables, with a
continuous outcome variable, is negligible. In this case, 'negligible'
represents the minimum meaningful interaction effect.

This test uses an intersection union approach, where a decision regarding
the omnibus interaction effect is inferred from the decision regarding all
simple (2 x 2) interaction effects; in other words, if all simple interaction
effects are deemed negligible, then the omnibus interaction is also
deemed negligible.

The test also uses the percentile bootstrap to determine confidence
intervals, an approach that has been found to be robust to violations
of normality and variance homogeneity.

See Cribbie, R. A., Ragoonanan, C., & Counsell, A. (2016). Testing for
negligible interaction: A coherent and robust approach. British Journal of
Mathematical and Statistical Psychology, 69, 159-174.
}
\examples{
outcome<-rnorm(60,mean=50,sd=10)
iv_1<-rep(c("male","female"),each=30)
iv_2<-rep(c("young","middle","old"),each=10,times=2)
d<-data.frame(iv_1,iv_2,outcome)
neg.intcat(iv1=iv_1,iv2=iv_2,dv=outcome,neiL=-15,neiU=15,nboot=10)
neg.intcat(iv1=iv_1,iv2=iv_2,dv=outcome,neiL=-15,neiU=15,nboot=10,data=d)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca}
}
