% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlog.R
\name{mantel.correlog}
\alias{mantel.correlog}
\title{Mantel (cross-)correlograms}
\usage{
mantel.correlog(
  dmat,
  zmat,
  wmat = NULL,
  increment,
  resamp = 999,
  quiet = FALSE
)
}
\arguments{
\item{dmat}{a matrix representing distance.}

\item{zmat}{a matrix representing similarity.}

\item{wmat}{an optional third matrix of similarities to calculate a Mantel cross-correlograms.}

\item{increment}{increment for the uniformly distributed distance classes.}

\item{resamp}{the number of permutations under the null to assess level of significance.}

\item{quiet}{If TRUE, the counter is suppressed during execution.}
}
\value{
An object of class "correlog" is returned, consisting of the following components: 
\item{correlation}{the value for the Moran (or Mantel) similarity.}
\item{mean.of.class}{the actual average of the distances within each distance class.}
\item{nlok}{the number of pairs within each distance class.}
\item{x.intercept}{the interpolate x.intercept of Epperson (1993).}
\item{p}{the permutation two-sided p-value for each distance-class.}
\item{corr0}{If a cross-correlogram is calculated, corr0 gives the empirical cross-correlation at distance zero.}
}
\description{
\code{mantel.correlog} is the function to calculate a Mantel (cross-)correlogram. The function requires two (or three) matrices.
}
\details{
The function calculates Mantel (cross-)correlograms at discrete distance classes from two (or three) matrixes. The first is the matrix of distances and the second is a matrix of similarities. The optional third matrix is an additional similarity matrix to be used to calculate a Mantel cross-correlogram.  Missing values are allowed -- values are assumed missing at random.
}
\examples{
# first generate some sample data
x <- expand.grid(1:20, 1:5)[, 1]
y <- expand.grid(1:20, 1:5)[, 2]

# z data from an exponential random field
z <- cbind(
  rmvn.spa(x = x, y = y, p = 2, method = "exp"), 
  rmvn.spa(x = x, y = y, p = 2, method = "exp")
  )

# w data from a gaussian random field
w <- cbind(rmvn.spa(
  x = x, y = y, p = 2, method = "gaus"), 
  rmvn.spa(x = x, y = y, p = 2, method = "gaus")
  )

# Make distance and similarity matrices
zmat <- cor(t(z))
wmat <- cor(t(w))
dmat <- sqrt(outer(x, x, "-")^2 + outer(y, y, "-")^2)

# Mantel correlogram 
fit1 <- mantel.correlog(dmat = dmat, zmat = zmat, increment = 2, quiet = TRUE, 
                        resamp = 0)
\dontrun{plot(fit1)}

# Mantel cross-correlogram 
fit2 <- mantel.correlog(dmat = dmat, zmat = zmat, wmat = wmat, increment = 2, 
                        quiet = TRUE, resamp = 0)
\dontrun{plot(fit2)}
}
\seealso{
\code{\link{plot.correlog}}
}
\author{
Ottar N. Bjornstad \email{onb1@psu.edu}
}
\keyword{spatial}
