% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_trajectory.R
\name{make_trajectory}
\alias{make_trajectory}
\title{Construct a \code{trajectory} object}
\usage{
make_trajectory(
  data,
  system = "ellipsoidal",
  start_time = NULL,
  name = NULL,
  ...
)
}
\arguments{
\item{data}{A multiple-column \code{matrix}. The first column corresponds to the measurment time (in seconds); columns 2, 3 and 4 corresponds to the positions (with the order lat, long and alt (in rad) if ellipsoidal coord or x_N, x_E and x_D for NED coord); columns 5, 6 and 7 (optional) corresponds to the attitude (with the order roll, pitch and yaw); columns 8, 9 and 10 (optional) corresponds to the velocity along the same axes are columns 2, 3 and 4.}

\item{system}{A \code{string} corresponding to the coordinate system (possible choices: \code{ellipsoidal} or \code{ned}) considered.}

\item{start_time}{A \code{string} (optional) corresponding to the start time for the trajectory.}

\item{name}{A \code{string} (optional) corresponding to the name of the dataset.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{trajectory}.
}
\description{
Create a \code{trajectory} object from simple matrix input.
}
\examples{
n <- 100
dat <- cbind(
  seq(from = 0, to = 60 * 60, length.out = n),
  46.204391 * pi / 180 + cumsum(rnorm(n)) / 10^5,
  6.143158 * pi / 180 + cumsum(rnorm(n)) / 10^5,
  375 + cumsum(rnorm(n))
)
traj <- make_trajectory(data = dat, name = "My cool data")
traj
plot(traj)
}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
