% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_timing.R
\name{make_timing}
\alias{make_timing}
\title{Construct a \code{timing} object}
\usage{
make_timing(
  nav.start = NULL,
  nav.end = NULL,
  freq.imu = NULL,
  freq.gps = NULL,
  freq.baro = NULL,
  gps.out.start = NULL,
  gps.out.end = NULL
)
}
\arguments{
\item{nav.start}{Time at which navigation starts}

\item{nav.end}{Time at which navigation ends}

\item{freq.imu}{Frequency of generated IMU data (and hence that of navigation)}

\item{freq.gps}{Frequency of generated GPS data}

\item{freq.baro}{Frequency of generated Baro data}

\item{gps.out.start}{Time at which GPS outage starts}

\item{gps.out.end}{Time at which GPS outage ends}
}
\value{
An object of class \code{timing} containing sensor name and its additive error model along with the frequency associated to that model
}
\description{
Construct a \code{timing} object controlling the timing and frequencies for navigation, making sure about the consistency and feasibility of provided information.
}
\examples{
timing <- make_timing(
  nav.start = 0,
  nav.end = 50,
  freq.imu = 10,
  freq.gps = 1,
  freq.baro = 1e-5,
  gps.out.start = 25.1,
  gps.out.end = 45
)

}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
