% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{reduce.df}
\alias{reduce.df}
\title{Internal function of naturaList - reduce data.frame of occurrence for a minimal
column length}
\usage{
reduce.df(
  df,
  institution.code = "institutionCode",
  collection.code = "collectionCode",
  catalog.number = "catalogNumber",
  year = "year",
  date.identified = "dateIdentified",
  species = "species",
  identified.by = "identifiedBy",
  decimal.latitude = "decimalLatitude",
  decimal.longitude = "decimalLongitude",
  basis.of.record = "basisOfRecord",
  media.type = "mediaType",
  occurrence.id = "occurrenceID",
  na.rm.coords = TRUE
)
}
\arguments{
\item{df}{occurrence data frame provided in {\link[naturaList]{classify_occ}}}

\item{institution.code}{institution.code = "institutionCode"}

\item{collection.code}{collection.code = "collectionCode"}

\item{catalog.number}{catalog.number = "catalogNumber"}

\item{year}{year = "year",}

\item{date.identified}{date.identified = "dateIdentified"}

\item{species}{species = "species"}

\item{identified.by}{identified.by = "identifiedBy"}

\item{decimal.latitude}{decimal.latitude = "decimalLatitude"}

\item{decimal.longitude}{decimal.longitude = "decimalLongitude"}

\item{basis.of.record}{basis.of.record = "basisOfRecord"}

\item{media.type}{media.type = "mediaType"}

\item{occurrence.id}{occ.id = "occurrenceID"}

\item{na.rm.coords}{na.rm.coords = TRUE}
}
\value{
a data frame with only the columns required for the \code{naturaList}
  package
}
\description{
Reduce columns of occurrence data.frame required by
{\link[naturaList]{classify_occ}} to facilitate internal operation
}
\seealso{
{\link[naturaList]{classify_occ}}
}
\keyword{internal}
