% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_occ.R
\name{classify_occ}
\alias{classify_occ}
\title{Classify occurrence records in levels of confidence in species identification}
\usage{
classify_occ(
  occ,
  spec = NULL,
  na.rm.coords = TRUE,
  crit.levels = c("det_by_spec", "not_spec_name", "image", "sci_collection", "field_obs",
    "no_criteria_met"),
  ignore.det.names = NULL,
  spec.ambiguity = "not.spec",
  institution.code = "institutionCode",
  collection.code = "collectionCode",
  catalog.number = "catalogNumber",
  year = "year",
  date.identified = "dateIdentified",
  species = "species",
  identified.by = "identifiedBy",
  decimal.latitude = "decimalLatitude",
  decimal.longitude = "decimalLongitude",
  basis.of.record = "basisOfRecord",
  media.type = "mediaType",
  occurrence.id = "occurrenceID",
  institution.source,
  year.event,
  scientific.name,
  determined.by,
  latitude,
  longitude,
  basis.of.rec,
  occ.id
)
}
\arguments{
\item{occ}{data frame with occurrence records information.}

\item{spec}{data frame with specialists' names. See details.}

\item{na.rm.coords}{logical. If \code{TRUE}, remove occurrences with \code{NA}
in \code{decimal.latitude} or \code{decimal.longitude}}

\item{crit.levels}{character. Vector with levels of confidence in decreasing
order. The criteria allowed are \code{det_by_spec}, \code{not_spec_name},
\code{image}, \code{sci_collection}, \code{field_obs}, \code{no_criteria_met}.
See details.}

\item{ignore.det.names}{character vector indicating strings in
\code{identified.by} that should be ignored as a taxonomist. See details.}

\item{spec.ambiguity}{character. Indicates how to deal with ambiguity in
specialists names. \code{not.spec} solve ambiguity by classifying the
identification as done by a non-specialist;\code{is.spec} assumes the
identification was done by a specialist; \code{manual.check} enables the
user to manually check all ambiguous names. Default is \code{not.spec}.}

\item{institution.code}{column name of \code{occ} with the name (or acronym)
in use by the institution having custody of the object(s) or information
referred to in the record.}

\item{collection.code}{column name of \code{occ} with The name, acronym,
code, or initials identifying the collection or data set from which the
record was derived.}

\item{catalog.number}{column name of \code{occ} with an identifier
(preferably unique) for the record within the data set or collection.}

\item{year}{Column name of \code{occ} the four-digit year in which the
Event occurred, according to the Common Era Calendar.}

\item{date.identified}{Column name of \code{occ} with the date on which the
subject was determined as representing the Taxon.}

\item{species}{column name of \code{occ} with the species names.}

\item{identified.by}{column name of \code{occ} with the name of who
determined the species.}

\item{decimal.latitude}{column name of \code{occ} latitude in decimal
degrees.}

\item{decimal.longitude}{column name of \code{occ} longitude in decimal
degrees.}

\item{basis.of.record}{column name with the specific nature of the data
record. See details.}

\item{media.type}{column name of \code{occ} with the media type of recording.
See details.}

\item{occurrence.id}{column name of \code{occ} with link or code for the
occurrence record. See in
\href{https://dwc.tdwg.org/terms/#dwc:occurrenceID}{Darwin Core Format}}

\item{institution.source}{deprecated, use \code{institution.code} instead.}

\item{year.event}{deprecated, use \code{year} instead.}

\item{scientific.name}{deprecated, use \code{species} instead.}

\item{determined.by}{deprecated, use \code{identified.by} instead}

\item{latitude}{deprecated, use \code{decimal.latitude} instead}

\item{longitude}{deprecated, use \code{decimal.longitude} instead}

\item{basis.of.rec}{deprecated, use \code{basis.of.record} instead.}

\item{occ.id}{deprecated, use \code{occurrence.id} instead}
}
\value{
The \code{occ} data frame plus the classification of each record
in a new column, named \code{naturaList_levels}.
}
\description{
Classifies occurrence records in levels of confidence in species
identification
}
\details{
\code{spec} data frame must have columns separating \code{LastName},
\code{Name} and \code{Abbrev}. See {\link[naturaList]{create_spec_df}}
function for a easy way to produce this data frame.

When \code{ignore.det.name = NULL} (default), the function ignores
strings with \code{"RRC ID Flag", "NA", "", "-" and "_".} When a character
vector is provided, the function adds the default strings to the provided
character vector and ignore all these strings as being a name of a taxonomist.

The function classifies the occurrence records in six levels of
confidence in species identification. The six levels are:
 \itemize{
 \item \code{det_by_spec} - when the identification was made by a specialists
    which is present in the list of specialists provided in the \code{spec}
    argument;
 \item \code{not_spec_name} - when the identification was made by a name who is
    not a specialist name provide in \code{spec};
 \item \code{image} - the occurrence have not name of a identifier, but present
    an image associated;
 \item \code{sci_collection} - the occurrence have not name of a identifier,
   but preserved in a scientific collection;
 \item \code{field_obs} - the occurrence have not name of a identifier,
   but it was identified in field observation;
 \item\code{no_criteria_met} - no other criteria was met.
}
 The (decreasing) order of the levels in the character vector determines the
 classification level order.

\code{basis.of.record} is a character vector with one of the following
types of record: \code{PRESERVED_SPECIMEN}, \code{PreservedSpecimen},
 \code{HUMAN_OBSERVATION} or \code{HumanObservation}, as in GBIF data
 'basisOfRecord'.

\code{media.type} uses the same pattern as GBIF mediaType column,
indicating the existence of an associated image with \code{stillImage}.
}
\examples{
data("A.setosa")
data("speciaLists")
occ.class <- classify_occ(A.setosa, speciaLists)


}
\seealso{
\code{\link{speciaLists}}
}
\author{
Arthur V. Rodrigues
}
