% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{emr_filter.create}
\alias{emr_filter.create}
\title{Creates a new named filter}
\usage{
emr_filter.create(
  filter,
  src,
  keepref = FALSE,
  time.shift = NULL,
  val = NULL,
  expiration = NULL,
  operator = "="
)
}
\arguments{
\item{filter}{filter name. If NULL - a name would be generated automatically using \code{emr_filter.name}.}

\item{src}{source (track name, virtual track name or id-time table). Can be a vector of track names.}

\item{keepref}{'TRUE' or 'FALSE'}

\item{time.shift}{time shift and expansion for iterator time}

\item{val}{selected values}

\item{expiration}{expiration period}

\item{operator}{operator for filtering. Accepts one of: "=", "<", "<=", ">", ">="}
}
\value{
Name of the filter (invisibly, if filter name wasn't generated automatically, otherwise - explicitly)
}
\description{
Creates a new named filter.
}
\details{
This function creates a new named filter.

'src' can be either a track name, a virtual track name, or an id-time table - data frame with the
first columns named "id", "time" and an optional "ref".

If 'val' is not 'NULL', the time window of the filter is required to contain
at least one value from the vector of 'val' which passes the 'operator' (see below).

'val' is allowed to be used only when 'src' is a name of a track. When val is specified,
the filter will filter the i.d, time points by applying the 'operator' argument on the
value of the point.

If 'expiration' is not 'NULL' and the filter window contains a value at time
't', the existence of previous values in the time window of [t-expiration,
t-1] (aka: "expiration window") is checked. If no such values are found in
the expiration window, the filter returns 'TRUE', otherwise 'FALSE'.

'expiration' is allowed to be used only when 'src' is a name of a
categorical track and 'keepref' is 'FALSE'.

'operator' corresponds to the 'val' argument. The point passes the filter
if the point's value passes the operator. For example if the point's value is 4,
the operator is "<" and val is 5, the expression evaluated is 4 < 5 (pass).
When 'operator' is not "=", 'vals' must exist, and be of length 1.

If both 'val' and 'expiration' are not 'NULL' then only values from 'val'
vector are checked both in time window and expiration window.

Note: 'time.shift' can be used only when 'keepref' is 'FALSE'.
Note:  A zero length vector is interpreted by R as NULL, so \code{val=c()} would create
a filter which returns all the values of \code{src}
}
\examples{

emr_db.init_examples()
emr_filter.create("f1", "dense_track", time.shift = c(2, 4))
emr_filter.create("f2", "dense_track", keepref = TRUE)
emr_extract("sparse_track", filter = "!f1 & f2")
}
\seealso{
\code{\link{emr_filter.attr.src}}, \code{\link{emr_filter.ls}},
\code{\link{emr_filter.exists}}, \code{\link{emr_filter.rm}}, \code{\link{emr_filter.create_from_name}}
}
\keyword{~filter}
