% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-mode.R
\name{impute_mode}
\alias{impute_mode}
\alias{impute_mode.default}
\alias{impute_mode.integer}
\alias{impute_mode.factor}
\title{Impute the mode value into a vector with missing values}
\usage{
impute_mode(x)

\method{impute_mode}{default}(x)

\method{impute_mode}{integer}(x)

\method{impute_mode}{factor}(x)
}
\arguments{
\item{x}{vector

This approach adapts examples provided \href{https://stackoverflow.com/questions/2547402/how-to-find-the-statistical-mode}{from stack overflow}, and for the integer
case, just rounds the value. While this can be useful if you are
imputing specific values, however we would generally recommend to impute
using other model based approaches. See the \code{simputation} package, for
example \code{\link[simputation:impute_lm]{simputation::impute_lm()}}.}
}
\value{
vector with mode values replaced
}
\description{
Impute the mode value into a vector with missing values
}
\examples{

vec <- rnorm(10)

vec[sample(1:10, 3)] <- NA

impute_mode(vec)

library(dplyr)

dat <- tibble(
  num = rnorm(10),
  int = rpois(10, 5),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat


dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_mode(num),
    int = impute_mode(int),
    fct = impute_mode(fct)
  )


}
