% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-median.R
\name{impute_median}
\alias{impute_median}
\alias{impute_median.default}
\alias{impute_median.factor}
\title{Impute the median value into a vector with missing values}
\usage{
impute_median(x)

\method{impute_median}{default}(x)

\method{impute_median}{factor}(x)
}
\arguments{
\item{x}{vector}
}
\value{
vector with median values replaced
}
\description{
Impute the median value into a vector with missing values
}
\examples{

vec <- rnorm(10)

vec[sample(1:10, 3)] <- NA

impute_median(vec)

library(dplyr)

dat <- tibble(
  num = rnorm(10),
  int = as.integer(rpois(10, 5)),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat

dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_median(num),
    int = impute_median(int),
  )

dat \%>\%
  nabular() \%>\%
  mutate(
    across(
      where(is.numeric),
      impute_median
    )
  )

dat \%>\%
  nabular() \%>\%
  mutate(
    across(
      c("num", "int"),
      impute_median
    )
 )

}
