% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/njira.r
\name{jira.query}
\alias{jira.query}
\title{Jira Query Interface}
\usage{
jira.query(table, fields = NULL, where = NULL, groupby = NULL)
}
\arguments{
\item{table}{Name of Jira table from which data will be fetched.}

\item{fields}{Comma separated names of the fields from the specified table whose values will be fetched.}

\item{where}{specifies the where clause of the query. You can also pass your Jira JQL as-is in the where clause.}

\item{groupby}{specifies the list of fields on which the data is grouped.}
}
\value{
Data frame of results returned by the Jira query.
}
\description{
Query Jira using SQL like query syntax.
The query response from Jira REST API is returned as a dataframe.
}
\details{
For querying Jira 'history' table, the where clause must specify issue 'id' \cr
Example : \code{where = "id = 'HIVE-22692'"}
}
\examples{
issues <- jira.query(table = "issues", fields = "id AS IssueId, Created, Status, Priority", 
where = "project = 'HIVE' AND created >= '2019-01-01' AND created <= '2019-12-31' AND 
Status IN ('Open', 'Closed', 'Resolved')")

issues <- jira.query(table = "issues", fields = "id AS IssueId, Created", 
where = "'cf[10021]' = 'ABCD' AND Created > '2019-01-01'")

history <- jira.query(table = "history", where = "id = 'HIVE-22692'")

history <- jira.query(table = "history", fields = "id AS IssueId, toString AS Status, 
COUNT(fromString) AS Count", where = "id = 'HIVE-22692' AND field = 'status'", 
groupby = "id,toString")

}
