% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzipmed_package.R
\name{binoutzimedint}
\alias{binoutzimedint}
\title{Mediation Analysis for Zero-Inflated Count Mediators using MZIP with Exposure-Mediator Interactions (Binary/Count Outcome)}
\usage{
binoutzimedint(
  outcome,
  mediator,
  exposure,
  confounder = NULL,
  C = NULL,
  n = 1000,
  X = 1,
  Xstar = 0,
  M = NULL,
  error = "Delta",
  robust = FALSE,
  zioff = NULL,
  rare = FALSE,
  OFF = NULL
)
}
\arguments{
\item{outcome}{is the continuous outcome variable}

\item{mediator}{is the zero-inflated mediator variable, currently only 1 mediator variable is allowed}

\item{exposure}{is the primary exposure being considered, only 1 is allowed}

\item{confounder}{is a vector of confounder variables. If no confounder variables are needed then confounder is set to NULL. If more than 1 confounder is being considered then use the cbind function, e.g. cbind(var1,var2)}

\item{C}{is a vector for theoretical values of each confounder. If left out the default will be set to the mean of each confounder giving marginal effects}

\item{n}{is the number of repetitions for bootstrapping. Default is 1000. Setting n when using delta method errors will have no effect on output.}

\item{X}{is the theoretical value for the exposure variable to be set at. The default is to 1}

\item{Xstar}{is the theoretical value for the exposure variable to be compared to X. The default is 0, so direct, indirect, and proportion mediated values will be for a 1 unit increase in the exposure variable.}

\item{M}{is a fixed value for the mediator, M. If M is not specified, M will be set to its mean value}

\item{error}{='Delta' for delta method standard errors and ='Boot' for bootstrap. Default is delta method}

\item{robust}{indicates if a robust covariance matrix should be used for MZIP in delta method derivations. Default is FALSE.}

\item{zioff}{(optional) use to specify an offset variable within the MZIP mediator model. Note: Mediator/Offset is used in the outcome model}

\item{rare}{set to TRUE of the outcome is rare and a logistic-regression should be used instead. Default is FALSE using robust Poisson model}

\item{OFF}{if an offset is specified a fixed value of the offset variable is required for derviation of effects. By default the mean is used.}
}
\value{
The function will return a list of 34 elements.
GLM is the results of regressing the mediator+exposure+confounder on the outcome using a Poisson model with robust standard errors. To assess interaction effect individually look in the glm statement at the 4th parameter estimate \cr
MZIP is the results of regressing the exposure and confounders on the mediator using the MZIP model \cr
RRCDE is the controlled direct effect risk ratio \cr
RRNDE is the natural direct effect risk ratio \cr
RRNIE is the indirect effect risk ratio. \cr
PM is the proportion mediated\cr
logRRCDEse is the standard error for the  controlled direct effect log risk ratio \cr
RRCDEci is the 95\% confidence interval for the controlled direct effect risk raito\cr
logRRNDEse is the standard error for the  natural direct effect log risk ratio \cr
RRNDEci is the 95\% confidence interval for the natural direct effect risk ratio\cr
logRRNIEse is the standard error for  the indirect effect log risk ratio \cr
RRNIEci is the 95\% confidence interval for the indirect effect risk ratio\cr
Intref is the Interactive Reference effect (not a risk ratio) \cr
Intrefse is the standard error for Intref \cr
IntrefCI is the CI for Intref \cr
RRPIE is the pure indirect effect risk ratio \cr
logRRPIEse is the standard error of PIE log risk ratio \cr
RRPIECI is the CI for PIE risk ratio \cr
Intmed is the interactive mediation effect (not a risk ratio) \cr
Intmedse is the error associated with Intmed \cr
IntmedCI is the CI for Intmed \cr
RRTE is the total effect risk ratio \cr
logRRTEse is the error of the total effect log risk ratio \cr
RRTECI is the CI for the total effect risk ratio\cr
Int is the overall additive interaction effect \cr
Intse is the standard error for the additive interaction \cr
IntCI is the confidence interval for the interaction effect \cr
PAINT is the proportion attributable to the interaction effect \cr
PE is the proportion eliminated \cr
PACDE is the proportion of the total effect due to neither mediation nor interaction \cr
PAIntref is the proportion of the total effect due to just interaction \cr
PAIntmed is the proportion of the total effect attributable to the joint effect of mediation and interaction \cr
PAPIE is the proportion of the total effect attributable to just mediation \cr
terr is the total excess relative risk
}
\description{
This function will do the same thing as the binoutzimed function, but includes an exposure-mediator interaction.
4-way decomposition of total effect (Vanderweele) are included in the output.
}
\examples{
   #Example with exposure-mediator interaction
   #This builds upon function without interaction
    zimmed=binoutzimedint(outcome=mzipmed_data$binY,mediator=mzipmed_data$ziM,
                   exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                   mzipmed_data$C2),error="Delta",robust=FALSE,X=1,Xstar=0,M=NULL,
                   C=NULL,zioff=NULL,OFF=NULL,rare=FALSE)
}
