% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk_lakes_by_state.R
\name{all_state_crosswalks}
\alias{all_state_crosswalks}
\alias{comid_to_ia}
\alias{comid_to_in}
\alias{comid_to_mi}
\alias{comid_to_mn}
\alias{comid_to_mo}
\alias{comid_to_nd}
\alias{comid_to_sd}
\alias{comid_to_wi}
\alias{ia_to_comid}
\alias{ia_to_lagos}
\alias{ia_to_mglp}
\alias{ia_to_nhd}
\alias{ia_to_nhdhr}
\alias{in_to_comid}
\alias{in_to_lagos}
\alias{in_to_mglp}
\alias{in_to_nhd}
\alias{in_to_nhdhr}
\alias{lagos_to_ia}
\alias{lagos_to_in}
\alias{lagos_to_mn}
\alias{lagos_to_mo}
\alias{lagos_to_nd}
\alias{lagos_to_sd}
\alias{lagos_to_wi}
\alias{mglp_to_ia}
\alias{mglp_to_in}
\alias{mglp_to_mi}
\alias{mglp_to_mn}
\alias{mglp_to_mo}
\alias{mglp_to_nd}
\alias{mglp_to_sd}
\alias{mglp_to_wi}
\alias{mi_to_comid}
\alias{mi_to_lagos}
\alias{mi_to_mglp}
\alias{mi_to_nhd}
\alias{mi_to_nhdhr}
\alias{mn_to_comid}
\alias{mn_to_lagos}
\alias{mn_to_nhd}
\alias{mn_to_nhdhr}
\alias{mo_to_comid}
\alias{mo_to_lagos}
\alias{mo_to_mglp}
\alias{mo_to_nhd}
\alias{mo_to_nhdhr}
\alias{nd_to_comid}
\alias{nd_to_lagos}
\alias{nd_to_mglp}
\alias{nd_to_nhd}
\alias{nd_to_nhdhr}
\alias{nhd_to_ia}
\alias{nhd_to_in}
\alias{nhd_to_mi}
\alias{nhd_to_mn}
\alias{nhd_to_mo}
\alias{nhd_to_nd}
\alias{nhd_to_sd}
\alias{nhd_to_wi}
\alias{nhdhr_to_ia}
\alias{nhdhr_to_in}
\alias{nhdhr_to_mi}
\alias{nhdhr_to_mn}
\alias{nhdhr_to_mo}
\alias{nhdhr_to_nd}
\alias{nhdhr_to_sd}
\alias{sd_to_comid}
\alias{sd_to_lagos}
\alias{sd_to_mglp}
\alias{sd_to_nhd}
\alias{sd_to_nhdhr}
\alias{wi_to_comid}
\alias{wi_to_lagos}
\alias{wi_to_mglp}
\alias{wi_to_nhd}
\alias{wi_to_nhdhr}
\title{A full list of state crosswalk functions}
\usage{
comid_to_ia(data, from_colname = "nhd.comid", agency = NULL, id_field = NULL)

comid_to_in(data, from_colname = "nhd.comid", agency = NULL)

comid_to_mi(data, from_colname = "nhd.comid", agency = NULL, id_field = NULL)

comid_to_mn(data, from_colname = "nhd.comid", agency = NULL)

comid_to_mo(data, from_colname = "nhd.comid", agency = NULL)

comid_to_nd(data, from_colname = "nhd.comid", agency = NULL)

comid_to_sd(data, from_colname = "nhd.comid", agency = NULL)

comid_to_wi(data, from_colname = "nhd.comid", agency = NULL)

ia_to_comid(data, from_colname, agency = NULL, id_field = NULL)

ia_to_lagos(data, from_colname, agency = NULL, id_field = NULL)

ia_to_mglp(data, from_colname, agency = NULL, id_field = NULL)

ia_to_nhd(data, from_colname, agency = NULL, id_field = NULL)

ia_to_nhdhr(data, from_colname, agency = NULL, id_field = NULL)

in_to_comid(data, from_colname, agency = NULL, id_field = NULL)

in_to_lagos(data, from_colname, agency = NULL)

in_to_mglp(data, from_colname, agency = NULL)

in_to_nhd(data, from_colname, agency = NULL)

in_to_nhdhr(data, from_colname, agency = NULL)

lagos_to_ia(data, from_colname = "lagos.id", agency = NULL, id_field = NULL)

lagos_to_in(data, from_colname = "lagos.id", agency = NULL)

lagos_to_mn(data, from_colname = "lagos.id", agency = NULL)

lagos_to_mo(data, from_colname = "lagos.id", agency = NULL)

lagos_to_nd(data, from_colname = "lagos.id", agency = NULL)

lagos_to_sd(data, from_colname = "lagos.id", agency = NULL)

lagos_to_wi(data, from_colname = "lagos.id", agency = NULL)

mglp_to_ia(data, from_colname = "mglp.id", agency = NULL, id_field = NULL)

mglp_to_in(data, from_colname = "mglp.id", agency = NULL)

mglp_to_mi(data, from_colname = "mglp.id", agency = NULL, id_field = NULL)

mglp_to_mn(data, from_colname = "mglp.id", agency = NULL)

mglp_to_mo(data, from_colname = "mglp.id", agency = NULL)

mglp_to_nd(data, from_colname = "mglp.id", agency = NULL)

mglp_to_sd(data, from_colname = "mglp.id", agency = NULL)

mglp_to_wi(data, from_colname = "mglp.id", agency = NULL)

mi_to_comid(data, from_colname, agency = NULL, id_field = NULL)

mi_to_lagos(data, from_colname, agency = NULL, id_field = NULL)

mi_to_mglp(data, from_colname, agency = NULL, id_field = NULL)

mi_to_nhd(data, from_colname, agency = NULL, id_field = NULL)

mi_to_nhdhr(data, from_colname, agency = NULL, id_field = NULL)

mn_to_comid(data, from_colname, agency = NULL)

mn_to_lagos(data, from_colname, agency = NULL)

mn_to_nhd(data, from_colname, agency = NULL)

mn_to_nhdhr(data, from_colname, agency = NULL)

mo_to_comid(data, from_colname, agency = NULL)

mo_to_lagos(data, from_colname, agency = NULL)

mo_to_mglp(data, from_colname, agency = NULL)

mo_to_nhd(data, from_colname, agency = NULL)

mo_to_nhdhr(data, from_colname, agency = NULL)

nd_to_comid(data, from_colname, agency = NULL)

nd_to_lagos(data, from_colname, agency = NULL)

nd_to_mglp(data, from_colname, agency = NULL)

nd_to_nhd(data, from_colname, agency = NULL)

nd_to_nhdhr(data, from_colname, agency = NULL)

nhd_to_ia(
  data,
  from_colname = "nhd.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

nhd_to_in(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhd_to_mi(
  data,
  from_colname = "nhd.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

nhd_to_mn(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhd_to_mo(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhd_to_nd(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhd_to_sd(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhd_to_wi(data, from_colname = "nhd.id", states = NULL, agency = NULL)

nhdhr_to_ia(data, from_colname = "nhdhr.id", agency = NULL, id_field = NULL)

nhdhr_to_in(data, from_colname = "nhdhr.id", agency = NULL)

nhdhr_to_mi(data, from_colname = "nhdhr.id", agency = NULL, id_field = NULL)

nhdhr_to_mn(data, from_colname = "nhdhr.id", agency = NULL)

nhdhr_to_mo(data, from_colname = "nhdhr.id", agency = NULL)

nhdhr_to_nd(data, from_colname = "nhdhr.id", agency = NULL)

nhdhr_to_sd(data, from_colname = "nhdhr.id", agency = NULL)

sd_to_comid(data, from_colname, agency = NULL)

sd_to_lagos(data, from_colname, agency = NULL)

sd_to_mglp(data, from_colname, agency = NULL)

sd_to_nhd(data, from_colname, agency = NULL)

sd_to_nhdhr(data, from_colname, agency = NULL)

wi_to_comid(data, from_colname, agency = NULL)

wi_to_lagos(data, from_colname, agency = NULL)

wi_to_mglp(data, from_colname, agency = NULL)

wi_to_nhd(data, from_colname, agency = NULL)

wi_to_nhdhr(data, from_colname, agency = NULL)
}
\arguments{
\item{data}{A data.set with a column containing a lake identifier
corresponding to one of the datasets listed above (also see lake_id_xref)}

\item{from_colname}{Character. The column name in \code{data} that lake IDs
that are being converted from (e.g. \code{data} has a lake ID column that
you are trying to convert from -- what is the name of that column)}

\item{agency}{Optional character vector specifying the agency to use for
the local ID column. This is helpful if data exist in lake_id_xref for
which there are more than one agency in a state that provided data}

\item{id_field}{Optional character vector specifying the id.field to use
for the local ID column. Occasionally states use more than one identifier.
This allows explicit choice of which identifier to use.}

\item{states}{Character. The two digit state abbreviation in lower case (
i.e. "wi", "mn", "mi", etc.). This will filter the crosswalk table to only
the states listed in this argument.}
}
\value{
A data.frame the same as \code{data}, but with an additional
lake identification column from lake_id_xref
}
\description{
This help file is simply to serve as a full list of all state shortcut
crosswalk functions. For functionality and examples, see
\code{\link{state_crosswalks}}.
}
