% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{msw}
\alias{msw}
\title{Shapiro-Wilk Type (SWT) Tests for Multivariate Normality}
\usage{
msw(X)
}
\arguments{
\item{X}{an \eqn{n*p} numeric matrix or data frame, the number of \eqn{n} must be between 3 and 5000, n>p.}
}
\value{
Returns a list with two objects:
\describe{
\item{\code{mv.test}}{a result table of multivariate normality tests,
including the name of the test, test statistic,
\emph{p}-value, and multivariate normality summary (Yes, if \emph{p}-value>0.05). Note that the test results
of \code{Royston} will not be reported if \eqn{n > 2000} or \eqn{n < 3} and the test results
of Villasenor-Alva and Gonzalez-Estrada (\code{VAGE}) will not be reported if  \eqn{n > 5000} or \eqn{n < 12}.}
\item{\code{uv.shapiro}}{a dataframe with \eqn{p} rows detailing univariate Shapiro-Wilk tests.
Columns in the dataframe contain test statistics \emph{W}, \emph{p}-value,and univariate normality summary (YES, if \emph{p}-value>0.05).}
If the number of variable is \eqn{p=1}, only univariate Shapiro-wilk's test result will be produced.}
}
\description{
The SWT-based tests for multivariate normality including Royston's H test and the test proposed
by Villasenor-Alva and Gonzalez-Estrada (2009).
}
\examples{
set.seed(12345)

## Data from gamma distribution
X = matrix(rgamma(50*4,shape =  2),50)
msw(X)

## Data from normal distribution
X = matrix(rnorm(50*4,mean = 2 , sd = 1),50)
msw(X)

## load the ubiquitous multivariate iris data ##
## (first 50 observations of columns 1:4) ##
iris.df = iris[1:50, 1:4]
msw(iris.df)

}
\references{
Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for normality (complete samples). \emph{Biometrika}, 52(3/4), 591-611.

Royston, J. P. (1982). An extension of Shapiro and Wilk's W test for normality to large samples. \emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 31(2), 115-124.

Villasenor Alva, J. A., & Estrada, E. G. (2009). A generalization of Shapiro–Wilk's test for multivariate normality. \emph{Communications in Statistics—Theory and Methods}, 38(11), 1870-1883.

Lee, R., Qian, M., & Shao, Y. (2014). On rotational robustness of Shapiro-Wilk type tests for multivariate normality. \emph{Open Journal of Statistics}, 4(11), 964.
}
\seealso{
\code{\link{power.mswR}}, \code{\link{power.mswV}}, \code{\link{mvnTest}}, \code{\link{faTest}}, \code{\link{msk}}, \code{\link{mardia}}, \code{\link{mhz}}, \code{\link[MVN]{mvn}}, \code{\link{shapiro.test}}
}
