% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{add_branch_condition}
\alias{add_branch_condition}
\alias{add_branch_condition.mverse}
\title{Add branch conditions to a \code{mverse} object.}
\usage{
add_branch_condition(.mverse, ...)

\method{add_branch_condition}{mverse}(.mverse, ...)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{...}{branch conditions.}
}
\value{
a \code{mverse} object.
}
\description{
This method adds one or more branch conditions to
an existing \code{mverse} object. Branch conditions
are used to specify an option in one branch dependent
on an option in another branch.
}
\examples{
# Define branches and add them to an \code{mverse} object.
y <- mutate_branch(alldeaths, log(alldeaths + 1))
distribution <- family_branch(poisson, gaussian)
# You can match branching options by providing the options
# the way provide them when defining branches.
match_poisson <- branch_condition(alldeaths, poisson)
mv <- mverse(hurricane) \%>\%
  add_mutate_branch(y) \%>\%
  add_family_branch(distribution) \%>\%
  add_branch_condition(match_poisson)
summary(mv)
# You can also condition to reject a pair of options by
# setting reject = TRUE.
match_log_lin <- branch_condition(log(alldeaths + 1), poisson, reject = TRUE)
mv <- add_branch_condition(mv, match_log_lin)
summary(mv)
}
\seealso{
Other branch condition functions: 
\code{\link{branch_condition}()}
}
\concept{branch condition functions}
