% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{threshold}
\alias{threshold}
\title{Non-parametric Threshold Estimation}
\usage{
threshold(pca_object, alpha = 0.001, ...)
}
\arguments{
\item{pca_object}{A list with class "pca" from the internal pca() function}

\item{alpha}{The upper 1 - alpha quantile of the SPE and T2 densities from
the training data passed to this function. Defaults to 0.001.}

\item{...}{Lazy dots for additional internal arguments}
}
\value{
A list with classes "threshold" and "pca" containing:
  \describe{
    \item{SPE_threshold -- }{the 1 - alpha quantile of the estimated SPE
      density}
    \item{T2_threshold -- }{the 1 - alpha quantile of the estimated Hotelling's
      T2 density}
    \item{projectionMatrix -- }{a projection matrix from the data feature space
      to the feature subspace which preserves some pre-specified proportion
      of the energy of the data scatter matrix. This pre-specified energy
      proportion is user supplied as the var.amnt argument in the pca()
      function. See the pca() function's help file for more details.}
    \item{LambdaInv -- }{a diagonal matrix of the reciprocal eigenvalues of the
      data scatter matrix}
    \item{T2 -- }{the vector of Hotelling's T2 test statistic values for each of the n
    observations in "data"}
    \item{SPE -- }{the vector of SPE test statistic values for each of the n
    observations in "data"}
  }
}
\description{
Calculate the non-parametric critical value threshold estimates
  for the SPE and T2 monitoring test statistics.
}
\details{
This function takes in a pca object returned by the pca() function
  and a threshold level defaulting to alpha = 0.1 percent of the
  observations. This critical quantile is set this low to reduce false
  alarms, as described in Kazor et al (2016). The function then returns a
  calculated SPE threshold corresponding to the 1 - alpha critical value, a
  similar T2 threshold, and the projection and Lambda Inverse (1 /
  eigenvalues) matrices passed through from the pca() function call.

  This internal function is called by faultFilter().
}
\examples{
nrml <- mspProcessData(faults = "NOC")
scaledData <- scale(nrml[,-1])
pca_obj <- pca(scaledData)
threshold(pca_object = pca_obj)

}
\seealso{
Called by: \code{\link{faultFilter}}. This function uses a port of
  the \code{quantile.density()} function from the now-orphaned BMS package.
}
