% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{getCosmicSignatures}
\alias{getCosmicSignatures}
\title{Obtain COSMIC mutational Signatures.}
\usage{
getCosmicSignatures(forceUseMirror = FALSE, asMutSign = TRUE)
}
\arguments{
\item{forceUseMirror}{logical, shall signatures be downloaded from a mirror. Set to TRUE if the COSMIC
server goes down.}

\item{asMutSign}{logical, shall data be returned as a mutSignatures-class object. Defaults to TRUE}
}
\value{
an object storing COSMIC mutational signature data
}
\description{
Obtain latest mutational Signature definitions from COSMIC. FOr more info, please visit: \url{https://cancer.sanger.ac.uk/cosmic/}
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
