% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{custom_fcnnls}
\alias{custom_fcnnls}
\title{Custom Fast Combinatorial Nonnegative Least-Square.}
\usage{
custom_fcnnls(mutCounts, signatures)
}
\arguments{
\item{mutCounts}{numeric matrix including mutation counts}

\item{signatures}{numeric matrix including mutation signatures}
}
\value{
list, including: (K) a numeric matrix of estimated exposures; and (Pset) a Pset numeric matrix
}
\description{
This function contributes to solve a least square linear 
problem using the fast combinatorial strategy from Van 
Benthem et al. (2004). This implementation is similar to that included in the
NMF R package by Renaud Gaujoux and Cathal Seoighe, 
and it is tailored to the data used in the mutational signature analysis. 
For more info, see: \url{https://CRAN.R-project.org/package=NMF}
}
\examples{
x <- mutSignatures:::getTestRunArgs(testN = "custom_fcnnls")
y <- mutSignatures:::custom_fcnnls(mutCounts = x$muts, signatures = x$signs)
y$coef
 
}
\keyword{internal}
