% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getMeasures}
\alias{getMeasures}
\title{Get measures}
\usage{
getMeasures(notes, beats = 4, beatType = 4, mxlDivision = 96, ...)
}
\arguments{
\item{notes}{list of notes (typically created by function getNotes).}

\item{beats}{number of beats (defaut signature is 4/4).}

\item{beatType}{beat type (defaut signature is 4/4).}

\item{mxlDivision}{Positive integer, musicXML "division" defining the
time resolution, i.e. the shortest possible note.
It is expressed as a fraction of a quarter note.
The value of 96 allows allows using 64th notes and their triplet/dotted versions.}

\item{...}{further arguments to be passed to function measure (typically, keySignature)}
}
\value{
A list of measure objects.
}
\description{
Create a series of measure objects from a series of notes.
}
\examples{
m <- getMeasures(notes=getNotes(pitches=pitchMapping(x=rnorm(100))))
}
