% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_duration.R
\name{duration}
\alias{duration}
\title{duration constructor.}
\usage{
duration(
  type,
  dot = FALSE,
  triplet = FALSE,
  mxlDivision = 96,
  mxlDuration = typeToMXLDuration(type, dot, triplet)
)
}
\arguments{
\item{type}{Integer in 2^(0:6), note type (longest 1=whole, shortest 64=64th).
1 = whole, 2 = half, 4 = quarter, 8 = eighth, etc. down to 64 = 64th}

\item{dot}{Logical, is note dotted?}

\item{triplet}{Logical, is note triplet? (play 3 for 2)}

\item{mxlDivision}{Positive integer, musicXML "division" defining the
time resolution, i.e. the shortest possible note.
It is expressed as a fraction of a quarter note.
The value of 96 allows allows using 64th notes and their triplet/dotted versions.}

\item{mxlDuration}{Positive integer, music XML "duration" expressed in
number of mxlDivision's. In general, mxlDivision/mxlDuration should not be modified.}
}
\value{
An object of class 'duration'.
}
\description{
Creates a new instance of a 'duration' object
}
\examples{
d <- duration(8,dot=TRUE)
}
