% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_multiattribute.R
\name{strategy_multiattribute}
\alias{strategy_multiattribute}
\title{Strategy Predictions for Multiattribute Decisions}
\usage{
strategy_multiattribute(cueA, cueB, v, strategy, c = 0.5, prior = c(1, 1))
}
\arguments{
\item{cueA}{cue values of Option A (-1/+1 = negative/positive; 0 = missing).
If a matrix is provided, each row defines one item type.}

\item{cueB}{cue values of Option B (see \code{cueA}).}

\item{v}{cue validities: probabilities that cues lead to correct decision.
Must be of the same length as the number of cues.}

\item{strategy}{strategy label, e.g., \code{"TTB"}, \code{"WADD"}, or \code{"WADDprob"}.
Can be a vector. See details.}

\item{c}{defines the upper boundary for the error probabilities}

\item{prior}{defines the prior distribution for the error probabilities
(i.e., truncated independent beta distributions \code{dbeta(prior[1], prior[2])} )}
}
\value{
a \code{strategy} object (a list) with the entries:
\describe{
\item{\code{pattern}: }{a numeric vector encoding the predicted choice pattern by the sign
       (negative = Option A, positive = Option B, 0 = guessing).
      Identical error probabilities are encoded by using the same absolute number
      (e.g., \code{c(-1,1,1)} defines one error probability with A,B,B predictions).}
\item{\code{c}: }{upper boundary of error probabilities}
\item{\code{ordered}: }{whether error probabilities are linearly ordered by their absolute value in \code{pattern} (largest error: smallest absolute number)}
\item{\code{prior}: }{a numeric vector with two positive values specifying the shape parameters of the beta prior distribution (truncated to the interval \code{[0,c]}}
\item{\code{label}: }{strategy label}
}
}
\description{
Returns a list defining the predictions of different choice strategies (e.g., TTB, WADD)
}
\examples{
# single item type
v <- c(.9, .8, .7, .6)
ca <- c(1, -1, -1, 1)
cb <- c(-1, 1, -1, -1)
strategy_multiattribute(ca, cb, v, "TTB")
strategy_multiattribute(ca, cb, v, "WADDprob")

# multiple item types
data(heck2017_raw)
strategy_multiattribute(
  heck2017_raw[1:10, c("a1", "a2", "a3", "a4")],
  heck2017_raw[1:10, c("b1", "b2", "b3", "b4")],
  v, "WADDprob"
)
}
