% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdk_install.R
\name{install_jdk}
\alias{install_jdk}
\alias{install_java}
\title{Install \code{jdk}}
\usage{
install_jdk(
  path = jdk_path(),
  version = "11",
  gui = TRUE,
  run = "ask",
  force = FALSE
)

install_java(
  path = jdk_path(),
  version = "11",
  gui = TRUE,
  run = "ask",
  force = FALSE
)
}
\arguments{
\item{path}{String; The location where jdk is (or should be) installed. See
\link{jdk_path} for more details on the default path used by \code{multilinguer}.}

\item{version}{String; Jdk version. Now only support "11". check inst/jdk.yaml.}

\item{gui}{Boolean; Some jdk supports os native installer. User can use
the gui when in interactive mode and use \code{Windows} or \code{MacOS}.}

\item{run}{c("ask","yes","no");If set "yes", installation proccess start. Default is "ask" to user.}

\item{force}{Boolean; force install when is TRUE. Default is FALSE.}
}
\description{
Install \code{openjdk} which is one of openjdk(java) distro.
Case of \code{MacOS}, remove all java and reinstall \code{corretto} version 11.
}
\examples{
\dontrun{
  install_java()
  install_jdk()
}
}
\seealso{
Other jdk-installer: 
\code{\link{jdk_path}()},
\code{\link{remove_jdk}()}

Other jdk-installer: 
\code{\link{jdk_path}()},
\code{\link{remove_jdk}()}
}
\concept{jdk-installer}
