% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmedmlmbrms.R
\name{extract.modmed.mlm.brms}
\alias{extract.modmed.mlm.brms}
\title{Post-processing of results from modmed.mlm.brms}
\usage{
extract.modmed.mlm.brms(
  brms.obj,
  type = c("indirect", "a", "b", "cprime", "covab", "indirect.diff", "a.diff", "b.diff",
    "cprime.diff"),
  ci.type = c("ECI"),
  ci.conf = 0.95,
  modval1 = NULL,
  modval2 = NULL
)
}
\arguments{
\item{brms.obj}{Result of \code{boot.modmed.mlm}}

\item{type}{Character indicating which piece of information to extract from the model
"indirect": value of the indirect effect.
"a": Current value of a path.
"b": Current value of b path.
"cprime": Current value of c path.
"covab": Random effect covariance between a and b paths, if both paths have associated random effects.
"indirect.diff": difference in indirect effect at two values of the moderator (set by \code{modval1} and \code{modval2}).
"a.diff": difference in a at two values of the moderator (set by \code{modval1} and \code{modval2}).
"b.diff": difference in b at two values of the moderator (set by \code{modval1} and \code{modval2}).
"cprime.diff": difference cprime at two values of the moderator (set by \code{modval1} and \code{modval2}).}

\item{ci.type}{Character indicating the type of confidence interval to compute. For now, just "ECI" is supported,
an equal-tailed credible interval.}

\item{ci.conf}{Numeric value indicating the confidence level for the credibility interval.}

\item{modval1}{If enabled, other quantities such as the indirect effect, a, b, and cprime, will be computed
at this particular value of the moderator. Otherwise, value of these quantities is directly extracted from
the model output (i.e., these would represent values of the effects when the moderator = 0).}

\item{modval2}{Second value of the moderator at which to compute the indirect effect.}
}
\value{
A list with two elements:
\itemize{
 \item{\code{CI} Point estimate (mean and median of posterior), sd, mad, credibility interval (quantiles), and other diagnostic information (rhat, ess_bulk, ess_tail).}
 \item{\code{draws} Contains \code{\link[posterior]{draws_matrix}} (from the posterior package) for quantity of interest. i.e., all posterior draws, for which the user may do additional work with.}
}
}
\description{
Post-processing of results from modmed.mlm.brms
}
\details{
This function generally assumes that type="all" was used when initially fitting the model, making all necessary
  information available for computation of indirect effects, differences between effects, and so on. If type="all"
  was not used, there is no guarantee that credibility intervals for the effects of interest can be extracted.
}
\examples{
\donttest{
data(BPG06dat)

# Note: 2000 iterations is just an example so that run time is not too long.
# Pick something larger (e.g., 5000+) in practice

# Only fixed effects with random intercept
fit<-modmed.mlm.brms(BPG06dat,"id", "x", "y" , "m", cores = 2,
                     iter = 2000, control = list(adapt_delta=0.95),
                     seed = 1234)


res.indirect <- extract.modmed.mlm.brms(fit, "indirect")
res.a <- extract.modmed.mlm.brms(fit, "a")
res.b <- extract.modmed.mlm.brms(fit, "b")
res.cprime <- extract.modmed.mlm.brms(fit, "cprime")

# Summary of results is in CI slot, example.
# Here, 95\% credibility interval is denoted by q2.5 and q97.5
res.indirect$CI

# Matrix of draws in another slot:
res.indirect$draws


}
}
