% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeans.R
\name{plotMeans}
\alias{plotMeans}
\title{Plot the means}
\usage{
plotMeans(
  x,
  by,
  plotCI = TRUE,
  alpha = 0.05,
  ylab = "averages",
  xlab = "",
  plotLegend = TRUE,
  inset = 0.01,
  xleg = "topleft",
  legPar = list(),
  gap = 0,
  labels = NULL,
  ...
)
}
\arguments{
\item{x}{Data frame with values of numeric variables.}

\item{by}{Categorical variable that defines groups.}

\item{plotCI}{Whether to plot confidence intervals or not, default is \code{TRUE}.}

\item{alpha}{A confidence level for calculating confidence intervals (default is \code{0.05}).}

\item{ylab}{The title of \eqn{y}-axis.}

\item{xlab}{The title of \eqn{x}-axis.}

\item{plotLegend}{Whether to plot a legend or not, default is \code{TRUE}.}

\item{inset}{Inset distance(s) from the margins as a fraction of the plot region when legend is placed by keyword.}

\item{xleg}{Position of a legend, default is \code{topleft}.}

\item{legPar}{Additional parameters for a legend. They have to be provided in a list format.}

\item{gap}{Space left between the center of the error bar and the lines marking the error bar in units of the height (width). Defaults to 1.0}

\item{labels}{Labels of x-axis.}

\item{\dots}{Arguments passed to functions \code{matplot} and \code{axis}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{means} - mean values by groups.
\item \code{CI} - widths of confidence intervals by groups.
}
}
\description{
The function plots the means of several numerical variables by the levels of one categorical variable.
}
\examples{
plotMeans(x = mtcars[, c(1, 3, 5)], by = mtcars[,8])
}
\author{
Aleš Žiberna
}
