% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRDPGtest.R
\name{multiRDPG_test}
\alias{multiRDPG_test}
\title{Performs test based on Multiple Random Dot Product Graph}
\usage{
multiRDPG_test(A, d, maxiter = 100, tol = 1e-06, B = 1000)
}
\arguments{
\item{A}{List of symmetric A matrices}

\item{d}{Dimension of the latent space}

\item{maxiter}{Maximum number of iterations in the fit of multiRDPG. Default is 100.}

\item{tol}{Tolerance for the step in the objective function in multiRDPG. Default is 1e-6.}

\item{B}{Number of permutation iterations. Default is 1000.}
}
\value{
Returns a list of the following elements:
\tabular{ll}{
           \code{pvalue}     \tab Estimated p-values \cr
           \code{Tval}       \tab Value of the test statistic \cr
           \code{Tstar}      \tab Vector of the test statistic for each permutation iteration \cr
           \code{nullmodel}  \tab Model fit under the null \cr
           \code{altmodel}   \tab Modelfit under the alternative
}
}
\description{
\code{multiRDPG_test} calculates the likelihood ratio test for whether a set of graphs
comes from the same disribution.
}
\examples{
#simulate data
U <- matrix(0, nrow=20, ncol=3)
U[,1] <- 1/sqrt(20)
U[,2] <- rep(c(1,-1), 10)/sqrt(20)
U[,3] <- rep(c(1,1,-1,-1), 5)/sqrt(20)

L<-list(diag(c(11,6,2)),diag(c(15,4,1)))
A <- list()
for(i in 1:2){
  P <- U\%*\%L[[i]]\%*\%t(U)
  A[[i]] <-apply(P,c(1,2),function(x){rbinom(1,1,x)})
  A[[i]][lower.tri(A[[i]])]<-t(A[[i]])[lower.tri(A[[i]])]
}

#perform test
multiRDPG_test(A,3,B=100)


}
\seealso{
\code{\link{multiRDPG}}
}
\author{
Agnes Martine Nielsen (agni@dtu.dk)
}
