#' Metro UI icons
#' @description Available metro UI icons.
#'
#' @return A character vector of length 700, the names of the available icons.
#' @export
#'
#' @examples
#' matrix(mui.icons(), ncol = 4L, byrow = TRUE)
mui.icons <- function(){
  c(
    "3d-rotation",
    "ac_unit",
    "accessible",
    "adb",
    "add",
    "add-photo",
    "add-shopping-cart",
    "air",
    "airplane",
    "alarm",
    "alarm-on",
    "amazon",
    "ambulance",
    "amex",
    "anchor",
    "android",
    "apple",
    "apps",
    "arrow-down",
    "arrow-down-left",
    "arrow-down-right",
    "arrow-drop-down",
    "arrow-drop-up",
    "arrow-left",
    "arrow-right",
    "arrow-up",
    "arrow-up-left",
    "arrow-up-right",
    "assignment",
    "attachment",
    "automobile",
    "backspace",
    "backspace1",
    "backward",
    "balance-scale",
    "barbell",
    "barcode",
    "battery-charge",
    "battery-empty",
    "battery-full",
    "battery-one",
    "battery-two",
    "beenhere",
    "bell",
    "bicycle",
    "bin",
    "bitcoin",
    "blocked",
    "blogger",
    "bluetooth",
    "bold",
    "book-reference",
    "bookmark",
    "bookmarks",
    "books",
    "brightness",
    "brightness-auto",
    "broadcast",
    "bt-audio",
    "bt-connected",
    "bt-disabled",
    "bt-searching",
    "bt-settings",
    "bubble",
    "bubbles",
    "bug",
    "bus",
    "cab",
    "cabinet",
    "cake",
    "calculator",
    "calculator2",
    "calendar",
    "camera",
    "camera-front",
    "camera-rear",
    "cancel",
    "cart",
    "cast",
    "cast-connected",
    "cc-paypal",
    "cell-no-internet",
    "cell-null",
    "cell-off",
    "cell-on",
    "cell-setting",
    "celsius",
    "chart-bars",
    "chart-bars2",
    "chart-dots",
    "chart-line",
    "chart-pie",
    "chat",
    "chat-bubble",
    "chat-bubble-outline",
    "checkmark",
    "chevron-left",
    "chevron-right",
    "chevron-thin-down",
    "chevron-thin-left",
    "chevron-thin-right",
    "chevron-thin-up",
    "chrome",
    "clipboard",
    "cloud",
    "cloud-download",
    "cloud-upload",
    "cloud2",
    "cloud3",
    "cloud4",
    "cloud5",
    "cloud6",
    "cloudy",
    "cloudy2",
    "cloudy3",
    "cloudy4",
    "cny",
    "codepen",
    "cog",
    "cogs",
    "coins",
    "command",
    "comment",
    "compass",
    "compass2",
    "computer",
    "contacts-dialer",
    "contacts-mail",
    "contrast",
    "copy",
    "copyright",
    "cpu",
    "create-new-folder",
    "creative-cloud",
    "creative-commons",
    "credit-card",
    "crop",
    "cross",
    "cross-light",
    "css3",
    "cut",
    "dashboard",
    "database",
    "delicious",
    "description",
    "developer_board",
    "deviantart",
    "devices",
    "dialer-sip",
    "dialpad",
    "dice",
    "digg",
    "directions-bike",
    "discord",
    "discout",
    "discover",
    "display",
    "document-file-3gp",
    "document-file-aac",
    "document-file-ai",
    "document-file-aiff",
    "document-file-app",
    "document-file-asp",
    "document-file-avi",
    "document-file-bmp",
    "document-file-c",
    "document-file-cpp",
    "document-file-css",
    "document-file-dat",
    "document-file-dmg",
    "document-file-doc",
    "document-file-docx",
    "document-file-dot",
    "document-file-dotx",
    "document-file-dwg",
    "document-file-dxf",
    "document-file-eps",
    "document-file-exe",
    "document-file-flv",
    "document-file-gif",
    "document-file-h",
    "document-file-html",
    "document-file-ics",
    "document-file-iso",
    "document-file-java",
    "document-file-jpg",
    "document-file-key",
    "document-file-m4v",
    "document-file-mid",
    "document-file-mov",
    "document-file-mp3",
    "document-file-mp4",
    "document-file-mpg",
    "document-file-numbers",
    "document-file-odp",
    "document-file-ods",
    "document-file-odt",
    "document-file-ots",
    "document-file-ott",
    "document-file-pages",
    "document-file-pdf",
    "document-file-php",
    "document-file-png",
    "document-file-pps",
    "document-file-ppt",
    "document-file-psd",
    "document-file-py",
    "document-file-qt",
    "document-file-rar",
    "document-file-rb",
    "document-file-rtf",
    "document-file-sql",
    "document-file-tga",
    "document-file-tgz",
    "document-file-tiff",
    "document-file-txt",
    "document-file-wav",
    "document-file-xls",
    "document-file-xlsx",
    "document-file-xml",
    "document-file-yml",
    "document-file-zip",
    "dollar",
    "dollar2",
    "dollars",
    "done",
    "done_all",
    "download",
    "download2",
    "drafts",
    "dribbble",
    "drive-eta",
    "drive1",
    "drive2",
    "dropbox",
    "earth",
    "earth2",
    "eject",
    "embed",
    "embed2",
    "enlarge",
    "enlarge2",
    "enter",
    "envelop",
    "equalizer",
    "equalizer-v",
    "equalizer2",
    "eur",
    "ev-station",
    "event-available",
    "event-busy",
    "evernote",
    "exit",
    "expand-less",
    "expand-more",
    "external",
    "eye",
    "eyedropper",
    "facebook",
    "facebook2",
    "fahrenheit",
    "favorite",
    "featured-play-list",
    "featured-video",
    "feed",
    "feed3",
    "female",
    "file-archive",
    "file-audio",
    "file-binary",
    "file-code",
    "file-download",
    "file-empty",
    "file-excel",
    "file-image",
    "file-movie",
    "file-music",
    "file-openoffice",
    "file-pdf",
    "file-picture",
    "file-play",
    "file-powerpoint",
    "file-text",
    "file-upload",
    "file-video",
    "file-word",
    "file-zip",
    "files-empty",
    "film",
    "filter",
    "finder",
    "fingerprint",
    "fire",
    "fire-extinguisher",
    "firefox",
    "first",
    "flag",
    "flash-auto",
    "flash-off",
    "flash-on",
    "flattr",
    "floppy-disk",
    "florist",
    "flow-branch",
    "flow-cascade",
    "flow-line",
    "flow-parallel",
    "flow-tree",
    "folder",
    "folder-download",
    "folder-minus",
    "folder-open",
    "folder-open2",
    "folder-plus",
    "folder-shared",
    "folder-special",
    "folder-special2",
    "folder-upload",
    "folder2",
    "fonticons",
    "forward",
    "foursquare",
    "gamepad",
    "gas-station",
    "gbp",
    "gift",
    "git",
    "github",
    "gitlab",
    "goat",
    "google",
    "google-plus",
    "google-plus2",
    "google-wallet",
    "grav",
    "hammer",
    "handshake",
    "hdd",
    "hdr-off",
    "hdr-on",
    "headphones",
    "heart",
    "heart-broken",
    "heartbeat",
    "help",
    "history",
    "home",
    "hotel",
    "hour-glass",
    "html5",
    "http",
    "IcoMoon",
    "ie",
    "image",
    "images",
    "imdb",
    "import-contacts",
    "import-export",
    "inbox",
    "indent-decrease",
    "indent-increase",
    "infinite",
    "info",
    "injection",
    "inr",
    "insert-drive-file",
    "insert-template",
    "instagram",
    "install",
    "italic",
    "joomla",
    "jsfiddle",
    "justice",
    "key",
    "keyboard",
    "keyboard-hide",
    "keyboard-return",
    "keyboard-tab",
    "keyboard-voice",
    "krw",
    "lab",
    "lamp",
    "lan",
    "language",
    "laptop",
    "last",
    "lastfm",
    "layers",
    "layers-clear",
    "leanpub",
    "library",
    "libreoffice",
    "lightning",
    "lightning2",
    "lightning3",
    "lightning4",
    "lightning5",
    "lines",
    "link",
    "linkedin",
    "linux",
    "list",
    "list-numbered",
    "list2",
    "local-airport",
    "local-service",
    "location",
    "location-city",
    "location-off",
    "lock",
    "lock-rotation",
    "looks",
    "loop",
    "loop2",
    "ltr",
    "magic-wand",
    "mail",
    "mail-read",
    "male",
    "map",
    "map2",
    "mars",
    "mastercard",
    "medal",
    "medium",
    "medkit",
    "meetup",
    "memory",
    "menu",
    "meter",
    "mic",
    "microscope",
    "minus",
    "mobile",
    "money",
    "moon",
    "moon2",
    "more-horiz",
    "more-vert",
    "motorcycle",
    "move-down",
    "move-up",
    "move_to_inbox",
    "multitrack-audio",
    "music",
    "my-location",
    "navigation",
    "near-me",
    "net-server",
    "network",
    "network-cell",
    "network-locked",
    "network-wifi",
    "new-tab",
    "news",
    "next",
    "none",
    "not",
    "note",
    "note-add",
    "notification",
    "odnoklassniki",
    "onedrive",
    "open-book",
    "opencart",
    "openid",
    "opera",
    "organization",
    "page-break",
    "paint",
    "palette",
    "pan-tool",
    "paper-plane",
    "paragraph-center",
    "paragraph-justify",
    "paragraph-left",
    "paragraph-right",
    "paste",
    "pause",
    "paw",
    "paypal",
    "pencil",
    "perm-phone-msg",
    "phone",
    "phone-bt",
    "phone-forwarded",
    "phone-in-talk",
    "phone-locked",
    "phone-missed",
    "phone-paused",
    "phonelink",
    "phonelink-erase",
    "phonelink-lock",
    "phonelink-off",
    "phonelink-ring",
    "phonelink-setup",
    "photo-camera",
    "photo-camera-enhance",
    "piano",
    "picassa",
    "pilcrow",
    "pin",
    "pinterest",
    "play",
    "plus",
    "power",
    "power-cord",
    "present-all",
    "previous",
    "print",
    "printer",
    "profile",
    "qa",
    "qrcode",
    "question",
    "quote",
    "rainy",
    "rainy2",
    "rainy3",
    "rainy4",
    "record_voice_over",
    "reddit",
    "redo",
    "refresh",
    "registered",
    "replay",
    "reply",
    "reply_all",
    "restaurant",
    "ring-volume",
    "rocket",
    "room",
    "rotation",
    "rouble",
    "rtl",
    "safari",
    "satellite",
    "school",
    "sd-card",
    "search",
    "section",
    "security",
    "server",
    "settings-ethernet",
    "settings-phone",
    "settings-power",
    "settings-voice",
    "share",
    "shareable",
    "shift",
    "ship",
    "shit",
    "shop",
    "shopping-basket",
    "shopping-basket2",
    "shrink",
    "shrink2",
    "shuffle",
    "sign-pen",
    "skype",
    "snowflake",
    "snowy",
    "snowy2",
    "snowy3",
    "snowy4",
    "snowy5",
    "sort-asc",
    "sort-desc",
    "soundcloud",
    "space-shuttle",
    "spell-check",
    "spinner",
    "spinner1",
    "spinner2",
    "spinner3",
    "spinner4",
    "spinner5",
    "spoon-fork",
    "squirrel",
    "stack",
    "stack2",
    "stack3",
    "stackoverflow",
    "star-empty",
    "star-full",
    "star-half",
    "steam",
    "steam2",
    "steps",
    "stethoscope",
    "stop",
    "strikethrough",
    "stumbleupon",
    "subscript",
    "subway",
    "suitcase",
    "sun",
    "sun3",
    "sun4",
    "sunrise",
    "superscript",
    "swarm",
    "switch",
    "sync-disabled",
    "sync-problem",
    "tab",
    "table",
    "tablet",
    "tablet-landscape",
    "tag",
    "tags",
    "target",
    "telegram",
    "themeisle",
    "thermometer",
    "thermometer2",
    "thumbs-down",
    "thumbs-up",
    "tools",
    "trademark",
    "traff",
    "traffic-cone",
    "train",
    "tree",
    "trophy",
    "truck",
    "try",
    "tux",
    "twitch",
    "twitter",
    "underline",
    "undo",
    "unfold-less",
    "unfold-more",
    "uninstall",
    "unlink",
    "unlock",
    "upload",
    "upload2",
    "usb",
    "usb1",
    "user",
    "user-check",
    "user-md",
    "user-minus",
    "user-plus",
    "user-secret",
    "users",
    "venus",
    "verified",
    "versions",
    "vertical-align-bottom",
    "vertical-align-center",
    "vertical-align-top",
    "video-camera",
    "vimeo",
    "visa",
    "vk",
    "voicemail",
    "volume-high",
    "volume-low",
    "volume-medium",
    "volume-minus",
    "volume-mute",
    "volume-mute2",
    "volume-plus",
    "vpn-lock",
    "vpn-publ",
    "warning",
    "watch",
    "water",
    "weather",
    "weather2",
    "weather3",
    "weather4",
    "weather5",
    "whatsapp",
    "widgets",
    "wifi-connect",
    "wifi-full",
    "wifi-lock",
    "wifi-low",
    "wifi-mid",
    "wifi-off",
    "wikipedia",
    "wind",
    "windows",
    "windy",
    "windy2",
    "windy3",
    "windy4",
    "windy5",
    "wordpress",
    "wrench",
    "yelp",
    "youtube",
    "youtube-play",
    "youtube2",
    "zoom-in",
    "zoom-out"
  )
}

#' Shiny app: metro UI icons
#' @description Launch a shiny app displaying all available metro UI icons.
#'
#' @return No returned value, the function just launches a Shiny app.
#'
#' @importFrom shiny shinyAppDir
#' @export
shinyMUIicons <- function(){
  appDir <- system.file("shinyapps", "icons", package = "multiActionButton")
  shinyAppDir(appDir)
}
