% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{pIntRule}
\alias{pIntRule}
\title{Product rule for numerical quadrature from univariate nodes and weights}
\usage{
pIntRule(x, dim = NULL)
}
\arguments{
\item{x}{Either a list with two elements $nodes and $weights representing a one dimensional quadrature formula which are then used for all dimensions, or a list where each element is a itself a list with two elements $nodes and $weights. In this case the respective quadrature rule is used for each dimension.}

\item{dim}{An integer that defines the dimension of the output quadrature formula. Default is NULL. If dim is NULL then x has to be a list of quadrature rules (list of lists) and the dimensions is automatically generated. If dim is a positive integer value the same quadrature rule is used in all dimensions.}
}
\value{
A list with a matrix of multivariate node points (each row is one point) and a vector of corresponding weights
}
\description{
The function allows to build a multivariate quadrature rule from univariate ones. The multivariate node points are all possible combinations of the univariate node points, and the final weights are the product of the respective univariate weights.
}
\examples{
require(statmod)
herm <- gauss.quad(2,"hermite")
lag <- gauss.quad(3,"laguerre")
qRule1 <- pIntRule(herm,2)
qRule2 <- pIntRule(list(herm,lag))
}
\author{
Klaus Herrmann
}
