% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{ggslice_projection}
\alias{ggslice_projection}
\title{Generate slice display}
\usage{
ggslice_projection(data, h, proj, center = NULL, col = NULL)
}
\arguments{
\item{data}{data frame containing only variables used for the display}

\item{h}{slice thickness}

\item{proj}{projection matrix from p to 2 dimensions}

\item{center}{center point vector used for anchoring the slice,
if NULL the mean of the data is used}

\item{col}{grouping vector mapped to color in the display}
}
\value{
ggplot2 object showing the sliced data
}
\description{
Generate slice display
}
\examples{
d <- geozoo::sphere.hollow(4, 1000)$points
ggslice_projection(d, 0.3, tourr::basis_random(4))
ggslice_projection(d, 0.3, tourr::basis_random(4),
                   center = c(0.4, 0.4, 0.4, 0.4))
}
\seealso{
ggslice
}
