% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORA.R
\docType{class}
\name{ora-class}
\alias{ora-class}
\alias{ora}
\title{An S4 class to represent a set based tests in mulea.}
\value{
ora object. This object represents the result of the
overrepresentation test in mulea.
}
\description{
An S4 class to represent a set based tests in mulea.
}
\section{Slots}{

\describe{
\item{\code{method}}{The overrepresentation (ora) method. Possible values:
"Hypergeometric", "SetBasedEnrichment".}

\item{\code{gmt}}{A \code{data.frame} representing the ontology GMT.}

\item{\code{element_names}}{A vector of elements names
(gene or protein names or identifiers) representing the target set to
analyse. For example
differentially expressed genes.}

\item{\code{background_element_names}}{A vector of elements names
(gene or protein names or identifiers) representing all the
elements involved in the previous analyses For example all
genes that were measured in differential expression analysis.}

\item{\code{p_value_adjustment_method}}{A character string representing the
type of the \emph{p}-value adjustment method. Possible values:
\itemize{
\item 'eFDR': empirical false discovery rate correction method
\item all \code{method} options from \code{stats::p.adjust} documentation.
}}

\item{\code{number_of_permutations}}{A numeric value representing the number of
permutations used to calculate the eFDR values. Default value is 10000.}

\item{\code{nthreads}}{Number of processor's threads to use in calculations.}

\item{\code{random_seed}}{Optional natural number (1, 2, 3, ...) setting the seed
for the random generator, to make the results reproducible.}
}}

\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(
    package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
        max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(package = "mulea", "extdata", 
        "target_set.txt"))
background_genes <- readLines(system.file(package="mulea", "extdata", 
        "background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered, 
        # the test set variable
        element_names = sign_genes, 
        # the background set variable
        background_element_names = background_genes, 
        # the p-value adjustment method
        p_value_adjustment_method = "eFDR", 
        # the number of permutations
        number_of_permutations = 10000,
        # the number of processor threads to use
        nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)
}
