% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{list_to_gmt}
\alias{list_to_gmt}
\title{Convert a list to ontology (GMT) \code{data.frame}.}
\usage{
list_to_gmt(gmt_list)
}
\arguments{
\item{gmt_list}{A list with named character vectors. The name will become the
'ontology_id', and the elements in the vector will become the
'list_of_values' in the ontology (GMT) \code{data.frame}.}
}
\value{
Returns ontology (GMT) \code{data.frame} where the 'ontology_name'
contains random unique strings.
}
\description{
Converts a list of ontology elements (gene sets) to an ontology
(GMT) \code{data.frame} object.
}
\examples{
library(mulea)

# creating a list of gene sets
ontology_list <- list(gene_set1 = c("gene1", "gene2", "gene3"),
        gene_set2 = c("gene4", "gene5", "gene6"))

# converting the list to a ontology (GMT) object
new_ontology_object <- list_to_gmt(ontology_list)
}
