% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msu.R
\name{msu}
\alias{msu}
\title{Estimating Multivariate Symmetrical Uncertainty.}
\usage{
msu(table_variables, table_class)
}
\arguments{
\item{table_variables}{A list of factors as categorical variables.}

\item{table_class}{A factor representing the class of the case.}
}
\value{
Multivariate symmetrical uncertainty estimation for the
    variable set \{\code{table_variables},
    \code{table_class}\}. The result is \code{round}ed to 7 decimal
    places.
}
\description{
MSU is a generalization of symmetrical uncertainty
(\code{\link[=symmetrical_uncertainty]{SU}}) where it is considered
the interaction between two or more variables, whereas SU can only
consider the interaction between two variables.  For instance,
consider a table with two variables X1 and X2 and a third variable,
Y (the class of the case), that results from the logical XOR
operator applied to X1 and X2 \tabular{ccc}{ X1 \tab X2 \tab Y\cr 0
\tab 0 \tab 0\cr 0 \tab 1 \tab 1\cr 1 \tab 0 \tab 1\cr 1 \tab 1
\tab 0\cr } For this case \deqn{MSU(X1, X2, Y) = 0.5.}  This, in
contrast to the measurements obtained by SU of the variables X1 and
X2 against Y, \deqn{SU(X1, Y) = 0} and \deqn{SU(X2, Y) = 0.}
}
\examples{
# completely predictable
msu(list(factor(c(0,0,1,1))), factor(c(0,0,1,1)))
# XOR
msu(list(factor(c(0,0,1,1)), factor(c(0,1,0,1))), factor(c(0,1,1,0)))
\dontrun{
msu(c(factor(c(0,0,1,1)), factor(c(0,1,0,1))), factor(c(0,1,1,0)))
msu(list(factor(c(0,0,1,1)), factor(c(0,1,0,1))), c(0,1,1,0))
}
}
\seealso{
\code{\link{symmetrical_uncertainty}}
}
