% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate.results}
\alias{generate.results}
\title{Generates clustering results}
\usage{
generate.results(g_clusters, distance.matrix)
}
\arguments{
\item{g_clusters}{A object of class igraph containing all component connected (cc=1).}

\item{distance.matrix}{A numeric matrix or data.frame with equals names and numbers of rows and columns representing objects to group.}
}
\value{
A list with the elements
\item{cnumber}{A numeric value representing the number of clusters of the solution.}
\item{cluster}{A named vector of integers of size n with values in range \code{1:cnumber}, representing the cluster to which each object is assigned.}
\item{partition}{A partition matrix order by cluster where are shown the objects and the cluster where they are assigned.}
\item{csize}{A vector of size k with the cardinality of each cluster in the solution.}
\item{network}{An object of class "igraph" as a network representing the clustering solution.}
}
\description{
This function performs the union the all component connected (cc) yield in each recursion of the MST-kNN algorithm.
}
\keyword{internal}
