% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstclustering.R
\name{mst.cluster}
\alias{mst.cluster}
\title{mst.cluster}
\usage{
mst.cluster(child.list.mst, m, k)
}
\arguments{
\item{child.list.mst}{The return value of the gen.child.list.mst() function with k-1 edges removed.}

\item{m}{Number of nodes.}

\item{k}{The number of clusters.}
}
\value{
A vector whose k-th element is the cluster the k-th point belongs to.
}
\description{
Run clustering using MST.
Before calling this function, remove some edges from the MST, for example the  k-1 heaviest.
}
\examples{
iris.clean <- iris[,-5]
iris.dist <- as.matrix(dist(iris.clean))
iris.edge.list <- gen.edge.list(iris.dist)
m <- nrow(iris.dist)
iris.mst.edge.list <- kruskal(iris.edge.list, m)
k <- 3
n.edges <- nrow(iris.mst.edge.list)
iris.mst.edge.list <- iris.mst.edge.list[1:(n.edges - (k - 1)),]
iris.child.list.mst <- gen.child.list.mst(iris.mst.edge.list, m)
iris.clust.mst <- mst.cluster(iris.child.list.mst, m, k)
}
