% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{msma}
\alias{msma}
\alias{msma.default}
\alias{print.msma}
\title{Multiblock Sparse Partial Least Squares}
\usage{
msma(X, ...)

\method{msma}{default}(
  X,
  Y = NULL,
  Z = NULL,
  comp = 2,
  lambdaX = NULL,
  lambdaY = NULL,
  lambdaXsup = NULL,
  lambdaYsup = NULL,
  eta = 1,
  type = "lasso",
  inX = NULL,
  inY = NULL,
  inXsup = NULL,
  inYsup = NULL,
  muX = 0,
  muY = 0,
  defmethod = "canonical",
  scaling = TRUE,
  verbose = FALSE,
  intseed = 1,
  ceps = 1e-04,
  ...
)

\method{print}{msma}(x, ...)
}
\arguments{
\item{X}{a matrix or list of matrices indicating the explanatory variable(s). This parameter is required.}

\item{...}{further arguments passed to or from other methods.}

\item{Y}{a matrix or list of matrices indicating objective variable(s). This is optional. If there is no input for Y, then PCA is implemented.}

\item{Z}{a vector, response variable(s) for implementing the supervised version of (multiblock) PCA or PLS. This is optional. The length of Z is the number of subjects. If there is no input for Z, then unsupervised PLS/PCA is implemented.}

\item{comp}{numeric scalar for the maximum number of componets to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X, with a length equal to the number of blocks. If lambdaX is omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y, with a length equal to the number of blocks. If lambdaY is omitted, no regularization is conducted.}

\item{lambdaXsup}{numeric vector of regularized parameters for the super weight of X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaYsup}{numeric vector of regularized parameters for the super weight of Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar indicating the parameter indexing the penalty family. This version contains only choice 1.}

\item{type}{a character, indicating the penalty family. In this version, only one choice is available: "lasso."}

\item{inX}{a vector or list of numeric vectors specifying the variables in X, always included in the model}

\item{inY}{a vector or list of numeric vectors specifying the variables in Y, always included in the model}

\item{inXsup}{a (list of) numeric vector to specify the blocks of X which are always in the model.}

\item{inYsup}{a (list of) numeric vector to specify the blocks of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised case. 0 <= muX <= 1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised case. 0 <= muY <= 1.}

\item{defmethod}{a character representing the deflation method. This version has only the choice "canonical."}

\item{scaling}{a logical, indicating whether or not data scaling is performed. The default is TRUE.}

\item{verbose}{information}

\item{intseed}{seed number for the random number in the parameter estimation algorithm.}

\item{ceps}{a numeric scalar for the convergence condition of the algorithm}

\item{x}{an object of class "\code{msma}", usually, a result of a call to \code{\link{msma}}}
}
\value{
\item{dmode}{Which modes "PLS" or "PCA"}

\item{X}{Scaled X which has a list form.}

\item{Y}{Scaled Y which has a list form.}

\item{Xscale}{Scaling information for X. The means and standard deviations for each block of X are returned.}

\item{Yscale}{Scaling information for Y. The means and standard deviations for each block of Y are returned.}

\item{comp}{the number of componets}

\item{wbX}{block loading for X}

\item{sbX}{block score for X}

\item{wbY}{block loading for Y}

\item{sbY}{block score for Y}

\item{ssX}{super score for X}

\item{wsX}{super loading for X}

\item{ssY}{super score for Y}

\item{wsY}{super loading for Y}

\item{nzwbX}{number of nonzeros in block loading for X}

\item{nzwbY}{number of nonzeros in block loading for Y}

\item{nzwsX}{number of nonzeros in super loading for X}

\item{nzwsY}{number of nonzeros in super loading for Y}

\item{selectXnames}{names of selected variables for X}

\item{selectYnames}{names of selected variables for Y}

\item{avX}{the adjusted variance of the score for X}

\item{avY}{the adjusted variance of the score for Y}

\item{cpevX}{the cumulative percentage of the explained variance for X}

\item{cpevY}{the cumulative percentage of the explained variance for Y}

\item{reproduct}{Predictivity. Correlation between Y and the predicted Y}

\item{predictiv}{Reproductivity. Correlation between the score for Y and the outcome Z}
}
\description{
This is a function for a matrix decomposition method incorporating sparse and supervised modeling for a multiblock multivariable data analysis
}
\details{
\code{msma} requires at least one input X (a matrix or list). In this case, (multiblock) PCA is conducted. If Y is also specified, then a PLS is conducted using X as explanatory variables and Y as objective variables. This function scales each data matrix to a mean of 0 and variance of 1 in the default. The block structure can be represented as a list. If Z is also specified, a supervised version is implemented, and the degree is controlled by muX or muY, where 0 <= muX <= 1, 0 <= muY <= 1, and 0 <= muX + muY < 1. If a positive lambdaX or lambdaY is specified, then a sparse estimation based on the L1 penalty is implemented.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component #####
fit1 = msma(X, Y, comp=1, lambdaX=2, lambdaY=1:3)
fit1

##### Two Component #####
fit2 = msma(X, Y, comp=2, lambdaX=2, lambdaY=1:3)
fit2

##### Sparse Principal Component Analysis #####
fit3 = msma(X, comp=5, lambdaX=2.5)
summary(fit3)

}
