% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mscp.r
\name{plot.mscp}
\alias{plot.mscp}
\title{plot.mscp}
\usage{
\method{plot}{mscp}(x = x, cex = 1, plot.legend = TRUE, ...)
}
\arguments{
\item{x}{object of class mscp}

\item{cex}{numeric, global sizes in plot}

\item{plot.legend}{logical, if TRUE legends are plotted}

\item{...}{additional arguments}
}
\value{
No return value, called for side effects
}
\description{
Plot method for class 'mscp'
}
\examples{
set.seed(1)
Tt <- 1000
cp <- c(250,500,600,650,750)
mu <- c(2,3,6,9,12,15)
sd <- c(1,1,2,1,2,1)
m  <- rep(mu,diff(c(0,cp,Tt))) 
s  <- rep(sd,diff(c(0,cp,Tt)))    
x  <- rnorm(Tt,m,s)
result <- mscp(x,kappa=4.77) # kappa set manually
# result <- mscp(x) # kappa derived in simulations
summary(result)
plot(result)

}
\references{
Multiscale change point detection via gradual bandwidth adjustment in moving sum processes (2021+), Tijana Levajkovic and Michael Messer
}
\seealso{
\code{\link{mscp}, \link{summary.mscp}}
}
\author{
Tijana Levajkovic and Michael Messer
}
