% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc.R
\name{mcr}
\alias{mcr}
\title{Multiple Correlation}
\usage{
mcr(dda, ld, rd, rawdata = T)
}
\arguments{
\item{dda}{Data}

\item{ld}{Dependent Variable}

\item{rd}{vector of independent variables}

\item{rawdata}{a boolean variable taking F if the input is a correlation matrix T if it is data matrix}
}
\value{
Returns the value of Multiple Correlation between dependent and independent variables
}
\description{
Computes Mutliple Correlation Coefficient between one variable and a set of variables
}
\examples{

## Example 1:
mcr(iris[,-5],1,c(2,3,4))  ## Returns multiple correlation between Sepal.Length
                          ## and the other variables

## Example 2
mu<-c(10,12,13,14)
sig<-matrix(0,4,4)
diag(sig)<-c(2,1,1,3)
da<-MASS::mvrnorm(25,mu,sig)
mcr(da, 2,c(1,3,4))       ## Returns Multiple correlation when the data matrix
                          ## simulated from a quadrivariate normal distribution
                          ## is given as input

## Example 3
da<-var(iris[,-5])
mcr(da,3,c(1,2,4),FALSE) ## Returns multiple correlation between Petal.Width
                         ## and the other variables when the correlation matrix
                         ## is given as input

}
\author{
Abirami S
}
