% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dht.se.R
\name{dht.se}
\alias{dht.se}
\title{Variance and confidence intervals for density and abundance estimates}
\usage{
dht.se(
  model,
  region.table,
  samples,
  obs,
  options,
  numRegions,
  estimate.table,
  Nhat.by.sample
)
}
\arguments{
\item{model}{ddf model object}

\item{region.table}{table of region values}

\item{samples}{table of samples(replicates)}

\item{obs}{table of observations}

\item{options}{list of options that can be set (see \code{\link{dht}})}

\item{numRegions}{number of regions}

\item{estimate.table}{table of estimate values}

\item{Nhat.by.sample}{estimated abundances by sample}
}
\value{
List with 2 elements: \item{estimate.table}{completed table with se,
cv and confidence limits} \item{vc }{correlation matrix of estimates}
}
\description{
Computes standard error, cv, and log-normal confidence intervals for
abundance and density within each region (if any) and for the total of all
the regions. It also produces the correlation matrix for regional and total
estimates.
}
\details{
The variance has two components:
\itemize{
  \item variation due to uncertainty from estimation of the detection
  function parameters;
  \item variation in abundance due to random sample selection.
}
The first component (model parameter uncertainty) is computed using a delta
method estimate of variance (\insertCite{huggins1989;nobrackets}{mrds}; \insertCite{huggins1991;nobrackets}{mrds}; \insertCite{borchers1998;nobrackets}{mrds}) in
which the first derivatives of the abundance estimator with respect to the
parameters in the detection function are computed numerically (see
\code{\link{DeltaMethod}}).

The second component (encounter rate variance) can be computed in one of
several ways depending on the form taken for the encounter rate and the
estimator used. To begin with there three possible values for \code{varflag}
to calculate encounter rate:
\itemize{
 \item \code{0} uses a negative binomial variance for the number of 
 observations (equation 13 of \insertCite{borchers1998;nobrackets}{mrds}). 
 This estimator is only 
 useful if the sampled region is the survey region and the objects are not 
 clustered; this situation will not occur very often;
 \item \code{1} uses the encounter rate \eqn{n/L} (objects observed per unit
 transect) from \insertCite{buckland2001;textual}{mrds} pg 78-79 (equation 3.78) for line
 transects (see also \insertCite{fewster2009;nobrackets}{mrds} estimator R2). This variance
 estimator is not appropriate if \code{size} or a derivative of \code{size}
 is used in the detection function;
 \item \code{2} is the default and uses the encounter rate estimator
 \eqn{\hat{N}/L} (estimated abundance per unit transect) suggested by
 \insertCite{innes2002;textual}{mrds} and \insertCite{marques2004;textual}{mrds}.
}

In general if any covariates are used in the models, the default
\code{varflag=2} is preferable as the estimated abundance will take into
account variability due to covariate effects. If the population is clustered
the mean group size and standard error is also reported.

For options \code{1} and \code{2}, it is then possible to choose one of the
estimator forms given in \insertCite{fewster2009;textual}{mrds}. For line transects:
\code{"R2"}, \code{"R3"}, \code{"R4"}, \code{"S1"}, \code{"S2"},
\code{"O1"}, \code{"O2"} or \code{"O3"} can be used by specifying \code{ervar} 
in the list of options provided by the \code{options} argument 
(default \code{"R2"}). For points, either the 
\code{"P2"} or \code{"P3"} estimator can be selected (>=mrds 2.3.0 
default \code{"P2"}, <= mrds 2.2.9 default \code{"P3"}). See 
\code{\link{varn}} and \insertCite{fewster2009;textual}{mrds}
 for further details on these estimators.

Exceptions to the above occur if there is only one sample in a stratum. In
this situation, \code{varflag=0} continues to use a negative binomial
variance while the other options assume a Poisson variance (\eqn{Var(x)=x}), 
where when \code{varflag=1} x is number of detections in the covered region and 
when \code{varflag=2} x is the abundance in the covered region. It also assumes 
a known variance so \eqn{z=1.96} is used for critical value. In all other cases 
the degrees of freedom for the \eqn{t}-distribution assumed for the
log(abundance) or log(density) is based on the Satterthwaite approximation
(\insertCite{buckland2001;nobrackets}{mrds} pg 90) for the degrees of freedom (df). The df are
weighted by the squared cv in combining the two sources of variation because
of the assumed log-normal distribution because the components are
multiplicative. For combining df for the sampling variance across regions
they are weighted by the variance because it is a sum across regions.

The coefficient of variation (CV) associated with the abundance estimates is calculated based on the following formula for the \code{varflag} options 1 and 2:

\code{varflag=1}

\deqn{CV(\hat{N}) = \sqrt{\left(\frac{\sqrt{n}}{n}\right)^2+CV(\hat{p})^2}}

\code{varflag=2}

\deqn{CV(\hat{N}) = \sqrt{\left(\frac{\sqrt{\hat{N}}}{\hat{N}}\right)^2+CV(\hat{p})^2}}
where n is the number of observations, \eqn{\hat{N}} is the estimated
abundance and \eqn{\hat{p}} is the average probability of detection for
an animal in the covered area. 

A non-zero correlation between regional estimates can occur from using a
common detection function across regions. This is reflected in the
correlation matrix of the regional and total estimates which is given in the
value list. It is only needed if subtotals of regional estimates are needed.
}
\note{
This function is called by \code{dht} and it is not expected that the
user will call this function directly but it is documented here for
completeness and for anyone expanding the code or using this function in
their own code.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{dht}}, \code{\link{print.dht}}
}
\author{
Jeff Laake
}
\keyword{utility}
