% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbsizeRsphere.R
\name{mrbsizeRsphere}
\alias{mrbsizeRsphere}
\title{Multiresolution analysis of random signals for spherical data.}
\usage{
mrbsizeRsphere(
  posteriorFile,
  mm,
  nn,
  lambdaSmoother,
  prob = 0.95,
  smoothOut = FALSE
)
}
\arguments{
\item{posteriorFile}{Matrix with posterior samples as column vectors.}

\item{mm}{Number of rows of the original object.}

\item{nn}{Number of columns of the original object.}

\item{lambdaSmoother}{Vector consisting of the smoothing levels to be used.}

\item{prob}{Credibility level for the posterior credibility analysis.}

\item{smoothOut}{Should the differences of smooths at neighboring scales be 
returned as output (FALSE by default)?}
}
\value{
A list containing the following sublists:

\code{smMean} Posterior mean of all differences of smooths created.

\code{hpout} Pointwise (PW) and highest pointwise (HPW) probabilities 
   of all differences of smooths created.

\code{ciout} Simultaneous credible intervals (CI) of all differences of
    smooths created.

\code{smoothSamples} Samples of differences of smooths at neighboring scales, 
    as column vectors.
}
\description{
\code{mrbsizeRSphere} is the interface of the scale space multiresolution method
for spherical data. Here, the differences of smooths as well as the posterior 
credibility analysis are computed. The output can be analyzed with the plotting
functions \code{\link{plot.smMeanSphere}}, \code{\link{plot.CImapSphere}} 
and \code{\link{plot.HPWmapSphere}}.
}
\details{
In contrast to \code{mrbsizeRgrid}, \code{mrbsizeRsphere} does not conduct 
Bayesian signal reconstruction via sampling from a posterior distribution. 
Samples of the posterior distribution have to be provided instead. 

For further information and examples, see \code{\link{mrbsizeRgrid}} and 
the vignette.
}
\examples{
# Artificial spherical sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(2000), nrow = 200)
sampleData[50:65, ] <- sampleData[50:65, ] + 5

# mrbsizeRsphere analysis
mrbOut <- mrbsizeRsphere(posteriorFile = sampleData, mm = 10, nn = 20,  
                          lambdaSmoother = c(1, 1000), prob = 0.95)
}
