% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpp_forward.R
\name{mpp_forward}
\alias{mpp_forward}
\title{MPP QTL analysis using forward regression}
\usage{
mpp_forward(
  pop.name = "MPP",
  trait.name = "trait1",
  mppData,
  trait = 1,
  Q.eff = "cr",
  ref.par = NULL,
  sum_zero = FALSE,
  threshold = 4,
  window = 30,
  backward = TRUE,
  alpha.bk = 0.05,
  plot.Qprof = FALSE,
  plot.gen.eff = FALSE,
  CI = FALSE,
  drop = 1.5,
  text.size = 18,
  n.cores = 1,
  verbose = TRUE,
  output.loc
)
}
\arguments{
\item{pop.name}{\code{Character} name of the studied population.
Default = "MPP".}

\item{trait.name}{\code{Character} name of the studied trait.
Default = "trait1".}

\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effect: 1) "cr" for cross-specific effects; 2) "par" parental
effects; 3) "anc" for an ancestral effects; 4) "biall" for a bi-allelic
effects. For more details see \code{\link{mpp_SIM}}. Default = "cr".}

\item{ref.par}{Optional \code{Character} expression defining the parental
allele that will be used as reference to calculate the allelic effects of 
the parental model. For the ancestral model, the ancestral class containing
the reference parent will be set as reference. \strong{This option can only
be used if the MPP design is composed of a unique connected part}.
Default = NULL.}

\item{sum_zero}{Optional \code{Logical} value specifying if the QTL effect of
a parental or an ancestral model should be caculated using the sum to zero
constraint. Default = FALSE.}

\item{threshold}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be considered as significant.
Default = 4.}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 30.}

\item{backward}{\code{Logical} value. If \code{backward = TRUE},
the function performs
a backward elimination on the list of selected QTLs. Default = TRUE.}

\item{alpha.bk}{\code{Numeric} value indicating the significance level for
the backward elimination. Default = 0.05.}

\item{plot.Qprof}{\code{Logical} value. If \code{plot = TRUE},
the function will plot the QTL profile last run of the forward regression.
Default = FALSE.}

\item{plot.gen.eff}{\code{Logical} value. If \code{plot.gen.eff = TRUE},
the function will save the decomposed genetic effects per cross/parent.
These results can be ploted with the function \code{\link{plot.QTLprof}}
to visualize a genome-wide decomposition of the genetic effects. This
plot will be realized on the last run of the forward regression.
\strong{This functionality is ony available for the cross-specific,
parental and ancestral models.}
Default value = FALSE.}

\item{CI}{\code{Logical} value. If \code{CI = TRUE}, the function will
compute a -log10(pval) drop confidence interval for each QTL using
the QTL profile of the last iteration. Default = FALSE.}

\item{drop}{\code{Numeric} -log10(p-value) drop value at the limits of the
interval. Default = 1.5.}

\item{text.size}{\code{Numeric} value specifying the size of graph axis text
elements. Default = 18.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{verbose}{\code{Logical} value indicating if the steps of the procedure
should be printed. Default = TRUE.}

\item{output.loc}{Path where a folder will be created to save the results.
By default the function uses the current working directory.}
}
\value{
Return:

List containing the following items:

\item{n.QTL}{Number of detected QTLs.}

\item{QTL}{\code{Data.frame} with QTL positions.}

\item{R2}{\code{List} containing R squared statistics of the QTL effects.
For details see \code{\link{QTL_R2}} output section.}

\item{QTL.effects}{\code{List} of QTLs genetic effects. For details see
\code{\link{QTL_gen_effects}} output section.}

\item{QTL.CI}{If \code{CI = TRUE}, confidence interval information of
the QTLs.}

Some output files are also saved at the specified location
(\code{output.loc}):

\enumerate{

\item{A QTL report (QTL_REPORT.txt) with: 1) the number of detected QTLs;
2) the global R squared statistics; 3) for each QTL, position information
(plus confidence interval if \code{CI = TRUE}) and estimated QTL genetic
effects per cross or parents (for details see \code{\link{QTL_gen_effects}}).}

\item{The list of QTL (QTL.txt).}

\item{The QTL R squared statistics (QTL_R2.txt) (for details see
\code{\link{QTL_R2}}).}

\item{If \code{CI = TRUE}, the QTL confidence intervals (QTL_CI.txt).}

\item{General results of the QTL detection process: number of QTLs and
global adjusted and non-adjusted R squared statistics (QTL_genResults.txt).}

\item{If \code{plot.Qprof = TRUE}, the plot of the last regression run
(QTL_profile.pdf). If \code{plot.gen.eff = TRUE}, plot of the genetic
effects per cross or parents (gen_eff.pdf) with dashed lines representing
the QTL positions. For more details see \code{\link{plot.QTLprof}}}

}
}
\description{
Multi-parent population QTL analysis model using a forward regression.
}
\details{
The function run a full MPP QTL detection using models with different possible
assumptions concerning the number of alleles at the QTL position. For more details about
the different models, see documentation of the function \code{\link{mpp_SIM}}.
The procedure is the following:

\enumerate{

\item{Forward regression to determine the a multi-QTL model. The function
selects successively QTL positions with -log10(pval) above the threshold.
Those positions are added as cofactors for following detection run.
The procedure stop when no more position has a -log10(pval) above the
threshold (\code{\link{QTL_forward}}).}

\item{If \code{backward = TRUE}, backward elimination  on the final
list of detected QTLs.} 

\item{Estimation of the QTL genetic effects and R squared statistics
(\code{\link{QTL_gen_effects}} and \code{\link{QTL_R2}}).}

\item{If \code{CI = TRUE}, confidence interval calculation  
based on a CIM- (composite interval mapping removing all cofactors on the
scanned chromosome) of the last run of the forward regression.}

\item{If \code{plot.Qprof = TRUE}, plot  of the last run of the forward
regression using \code{\link{plot.QTLprof}}.}

\item{If \code{plot.gen.eff = TRUE}, plot of the genetic effect distribution
along the genome of the last run of the forward regression using
\code{\link{plot.QTLprof}}.}

}
}
\examples{

\dontrun{

data(mppData)

# Specify a location where your results will be saved
my.loc <- "C:/.../..."

# Cross-specific model

USNAM_cr <- mpp_forward(pop.name = "USNAM", trait.name = "ULA",
                        mppData = mppData, plot.gen.eff = TRUE,
                        plot.Qprof = TRUE, CI = TRUE, output.loc = my.loc)


}

}
\seealso{
\code{\link{mpp_SIM}}, \code{\link{plot.QTLprof}},
\code{\link{QTL_gen_effects}}, \code{\link{QTL_forward}}, \code{\link{QTL_R2}}
}
\author{
Vincent Garin
}
