% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_connectectivity.R
\name{design_connectivity}
\alias{design_connectivity}
\title{Connected parts of a MPP design}
\usage{
design_connectivity(par_per_cross, plot_des = TRUE, output_loc = NULL)
}
\arguments{
\item{par_per_cross}{Three columns \code{character matrix} specifying :
1) the cross indicators ; 2) the parents 1 identifiers of the crosses;
3) the parents 2 identifiers of the crosses.}

\item{plot_des}{\code{Logical} value indicating if connected part of the
design should be plotted. Default = TRUE.}

\item{output_loc}{Path where the plot of the design will be saved if the
argument is given. Default = NULL.}
}
\value{
Return a list with each element representing one connected part of the design
and the list of parents contained in this part.

If \code{plot_des = TRUE} and \code{output_loc} has been specified. A plot
of the graph (con_plot.pdf) will be saved at the specified location.
}
\description{
Determine the connected parts of a MPP design using the method of Weeks and
Williams (1964) and the package igraph.
}
\examples{

data(mppData)

par_per_cross <- mppData$par.per.cross

con.part <- design_connectivity(par_per_cross)

}
\references{
Weeks, D. L., & Williams, D. R. (1964). A note on the determination of
connectedness in an N-way cross classification. Technometrics, 6(3), 319-324.
}
\author{
Vincent Garin
}
