% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{plot_power_spectrum}
\alias{plot_power_spectrum}
\title{Plot a power spectrum of a wavelet object}
\usage{
plot_power_spectrum(obj, view, ...)
}
\arguments{
\item{obj}{analyze.wavelet object.}

\item{view}{View object.}

\item{...}{passed to \code{\link[WaveletComp:wt.image]{WaveletComp::wt.image()}}.}
}
\value{
a list of class \verb{graphical parameters}.
}
\description{
Plot a power spectrum of a wavelet object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
pv1 <- subset(pv, Time >= 30)
w <- analyze_wavelet(pv1, "Nose_y")
plot_power_spectrum(w, pv1)
w <- analyze_wavelet(pv1, "Nose_y", lowerPeriod = 0.01, upperPeriod = 10)
plot_power_spectrum(w, pv1)
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
