% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_main.R
\name{movedesign_output}
\alias{movedesign_output}
\title{Create a \code{movedesign_output} object to store simulation outputs}
\usage{
movedesign_output(input)
}
\value{
An S3 object of class \code{movedesign_output} containing simulation
outputs, summaries, and associated metadata.
}
\description{
Constructs an S3 object of class \code{movedesign_output} that stores the
outputs and summaries from a specific simulation workflow. The
resulting object bundles all relevant metadata from the original
study design (inputs), simulation outputs (e.g., home range or
speed estimates), and post-processing summaries (e.g., errors,
credible intervals).

The \code{movedesign_output} object is returned by simulation functions like
\code{\link[=md_run]{md_run()}} or \code{\link[=md_replicate]{md_replicate()}}, and acts as the primary data
structure for downstream analyses and visualization via
functions such as \code{\link[=md_plot]{md_plot()}} or \code{\link[=md_check]{md_check()}}.
}
\seealso{
\code{\link[=md_run]{md_run()}},
\code{\link[=md_replicate]{md_replicate()}},
\code{\link[=md_check]{md_check()}},
\code{\link[=md_plot]{md_plot()}}
}
\keyword{internal}
