% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_optimize}
\alias{md_optimize}
\title{Optimize population sample size and sampling parameters}
\usage{
md_optimize(
  obj,
  n_replicates = NULL,
  error_threshold = NULL,
  verbose = FALSE,
  trace = TRUE,
  parallel = FALSE,
  ncores = parallel::detectCores(),
  plot = FALSE,
  ...
)
}
\arguments{
\item{obj}{A movement design input object (see \code{\link[=md_prepare]{md_prepare()}}
or \code{\link[=md_configure]{md_configure()}}).}

\item{n_replicates}{Integer. Number of simulation replicates at each
candidate sample size.}

\item{error_threshold}{Numeric. Error threshold (e.g. \code{0.05} for 5\%)
to display as a reference in the plot.}

\item{verbose}{Logical. If \code{TRUE} (default), prints a summary
of the convergence check to the console.}

\item{trace}{Logical; if \code{TRUE} (default), prints progress and
timing messages to the console.}

\item{parallel}{Logical; if \code{TRUE}, enables parallel processing.
Default is \code{FALSE}.}

\item{ncores}{Integer; number of CPU cores to use for parallel
processing. Defaults to all available cores detected by
\code{parallel::detectCores()}.}

\item{plot}{Logical. If TRUE, displays a diagnostic plot of
the final results.}

\item{...}{Additional arguments used internally.}
}
\value{
A list of class \code{movedesign_report} containing:
\itemize{
\item \code{summary}: Data frame of summary statistics for each
replicate, sample size, and metric.
\item \code{error_threshold}: Numeric. The error threshold used.
\item \code{sampling_duration}: Character string. Final sampling duration.
\item \code{sampling_interval}: Character string. Final sampling interval.
\item \code{sample_size_achieved}: Logical. Indicates if convergence was
achieved and the threshold met.
\item \code{minimum_population_sample_size}: Integer. Minimum sample size
achieving the threshold (or maximum evaluated if
\code{sample_size_achieved} is \code{FALSE}).
}
}
\description{
Repeatedly simulates movement datasets across a range of
candidate population sample sizes to identify the minimal sample size
and associated sampling parameters (e.g., duration, sampling interval)
required to achieve a predefined error threshold for key space-use and
movement metrics (home range area, or speed).

The function quantifies estimation error for each metric and sample
size, evaluates which population sample size reliably meets target
thresholds, and reports final recommendations.
}
\details{
The function iteratively runs movement design simulations for
increasing population sample sizes (\code{m}), evaluating error for
each replicate and metric via meta-analyses. Convergence is checked
using the error threshold and stability of cumulative mean error.
The function stops when a sample size meets all criteria or the
maximum population sample size is reached. Results can be visualized
using if \code{plot = TRUE}.
}
\note{
Some biologgers inherently involve a trade-off between fix frequency
and battery life. Shorter intervals between location fixes offer higher
temporal resolution but reduce deployment duration due to increased
power consumption. In contrast, longer deployments require less
frequent sampling to conserve battery.

This trade-off makes it challenging to estimate multiple metrics with
differing data needs: high-resolution data (shorter intervals) improve
speed estimation, while extended deployments (longer durations) are
vital for accurate home range area estimates. A sampling design that
minimizes error for one metric may increase error for another.

Researchers facing these constraints should consider prioritizing a
single research target (e.g., either home range area \emph{or} speed), or
use stratified designs to balance data needs across individuals.
}
\examples{
if(interactive()) {
  obj <- md_configure(data = buffalo,
                      models = models)
                      
  out <- md_optimize(tmp,
                     n_replicates = 25,
                     error_threshold = 0.05,
                     plot = TRUE)
}

}
\seealso{
\code{\link[=md_prepare]{md_prepare()}}, \code{\link[=md_configure]{md_configure()}}
}
