% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_circle_left.R
\name{time_circle_left}
\alias{time_circle_left}
\title{Initiation Time}
\usage{
time_circle_left(
  x_vector,
  y_vector,
  t_vector,
  x_mid = 0,
  y_mid = 0,
  radius = 1,
  include_radius = TRUE,
  warn = TRUE
)
}
\arguments{
\item{x_vector}{x-coordinates of the executed path.}

\item{y_vector}{y-coordinates of the executed path.}

\item{t_vector}{Timestamps of the executed trajectory.}

\item{x_mid}{x-coordinate of the center of the circle.}

\item{y_mid}{y-coordinate of the center of the circle.}

\item{radius}{radius of the center of the circle.}

\item{include_radius}{Whether points lying exactly on the radius should be
included in the circle. Defaults to \code{TRUE}.}

\item{warn}{whether a warning should be thrown if the first entry of t_vector
is returned. Defaults to \code{TRUE}.}
}
\value{
Value of \code{t_vector} at the first time at which the trajectory
is out of the circle.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Checks when the specified circle was first left by a trajectory.
}
\examples{
time_circle_left(0:10, rep(0, 11), 0:10)
time_circle_left(0:10, rep(0, 11), 0:10, include_radius = FALSE)

}
\references{
Wirth, R., Foerster, A., Kunde, W., & Pfister, R. (2020).
Design choices: Empirical recommendations for designing two-dimensional
finger tracking experiments. Behavior Research Methods, 52, 2394 - 2416.
\doi{10.3758/s13428-020-01409-0}
}
