#' Models Of Trait Macroevolution On Trees
#' 
#' Functions for fitting models of trait evolution on phylogenies for continuous traits. The majority of functions described in Thomas and Freckleton (2012) and include functions that allow for tests of variation in the rates of trait evolution.
#' 
#' @name motmot-package
#' @aliases motmot
#'
#' @docType package
#'
#' @author Mark Puttick <marknputtick@gmail.com>.
#' @author Gavin Thomas.
#' @author Travis Ingram.
#' @author Magnus Clarke. 
#' @author Rob Freckleton.
#' @author David Orme.
#' @author Emmanuel Paradis.

#' @keywords package

#' @references Thomas GH, & Freckleton R. 2012. Body size diversification in Anolis: novel environments and island effects. MOTMOT: models of trait macroevolution on trees 3, 145-151.

## usethis namespace: start
#' @importFrom Rcpp sourceCpp
#' @useDynLib motmot, .registration = TRUE
## usethis namespace: end
NULL
